/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.sampler;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.sampler.Sampler;
import com.navercorp.pinpoint.profiler.context.provider.sampler.SamplerConfig;
import com.navercorp.pinpoint.profiler.sampler.CountingSamplerFactory;
import com.navercorp.pinpoint.profiler.sampler.FalseSampler;
import com.navercorp.pinpoint.profiler.sampler.PercentSamplerFactory;
import com.navercorp.pinpoint.profiler.sampler.SamplerFactory;
import com.navercorp.pinpoint.profiler.sampler.SamplerType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SamplerProvider
implements Provider<Sampler> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;

    @Inject
    public SamplerProvider(ProfilerConfig profilerConfig) {
        this.profilerConfig = profilerConfig;
    }

    public Sampler get() {
        SamplerConfig config = new SamplerConfig(this.profilerConfig);
        this.logger.info("SamplerConfig:{}", (Object)config);
        if (!config.isSamplingEnable()) {
            return FalseSampler.INSTANCE;
        }
        SamplerType samplerType = config.getSamplerType();
        SamplerFactory samplerFactory = this.newSamplerFactory(samplerType, this.profilerConfig);
        return samplerFactory.createSampler();
    }

    private SamplerFactory newSamplerFactory(SamplerType samplerType, ProfilerConfig profilerConfig) {
        switch (samplerType) {
            case COUNTING: {
                return this.newCountingSamplerFactory(profilerConfig);
            }
            case PERCENT: {
                return this.newPercentSamplerFactory(profilerConfig);
            }
        }
        throw new IllegalStateException("Unexpected samplerType: " + (Object)((Object)samplerType));
    }

    private SamplerFactory newCountingSamplerFactory(ProfilerConfig profilerConfig) {
        CountingSamplerFactory.Config config = CountingSamplerFactory.config(profilerConfig);
        this.logger.info("CountingSamplerFactory.Config:{}", (Object)config);
        return new CountingSamplerFactory(config);
    }

    private SamplerFactory newPercentSamplerFactory(ProfilerConfig profilerConfig) {
        PercentSamplerFactory.Config config = PercentSamplerFactory.config(profilerConfig);
        this.logger.info("PercentSamplerFactory.Config:{}", (Object)config);
        return new PercentSamplerFactory(config);
    }
}

