/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunkFactory;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogStorageFactory
implements StorageFactory {
    public static final Storage DEFAULT_STORAGE = new LogStorage();

    @Override
    public Storage createStorage(SpanChunkFactory spanChunkFactory) {
        return DEFAULT_STORAGE;
    }

    public static class LogStorage
    implements Storage {
        private final Logger logger = LogManager.getLogger(this.getClass());

        @Override
        public void store(SpanEvent spanEvent) {
            this.logger.debug("log spanEvent:{}", (Object)spanEvent);
        }

        @Override
        public void store(Span span) {
            this.logger.debug("log span:{}", (Object)span);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

