/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.instrument.ClassInputStreamProvider;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.IOUtils;
import com.navercorp.pinpoint.profiler.instrument.ASMClassWriter;
import com.navercorp.pinpoint.profiler.instrument.ASMFieldNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.ASMMethodInsnNodeRemapper;
import com.navercorp.pinpoint.profiler.instrument.ASMMethodNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.scanner.ClassScannerFactory;
import com.navercorp.pinpoint.profiler.instrument.scanner.Scanner;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import com.navercorp.pinpoint.profiler.util.StringMatchUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMClassNodeAdapter {
    private static final Logger logger = LogManager.getLogger(ASMClassNodeAdapter.class);
    private final ClassInputStreamProvider pluginInputStreamProvider;
    private final ClassLoader classLoader;
    private final ProtectionDomain protectionDomain;
    private final ClassNode classNode;
    private final boolean skipCode;

    public static ASMClassNodeAdapter get(ClassInputStreamProvider pluginClassInputStreamProvider, ClassLoader classLoader, ProtectionDomain protectionDomain, String classInternalName) {
        return ASMClassNodeAdapter.get(pluginClassInputStreamProvider, classLoader, protectionDomain, classInternalName, false);
    }

    public static ASMClassNodeAdapter get(ClassInputStreamProvider pluginClassInputStreamProvider, ClassLoader classLoader, ProtectionDomain protectionDomain, String classInternalName, boolean skipCode) {
        Objects.requireNonNull(pluginClassInputStreamProvider, "pluginInputStreamProvider");
        Objects.requireNonNull(classInternalName, "classInternalName");
        String classPath = classInternalName.concat(".class");
        byte[] bytes = ASMClassNodeAdapter.readStream(classPath, pluginClassInputStreamProvider, protectionDomain, classLoader);
        if (bytes == null) {
            return null;
        }
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        int parsingOptions = ASMClassNodeAdapter.getParsingOption(skipCode);
        classReader.accept((ClassVisitor)classNode, parsingOptions);
        return new ASMClassNodeAdapter(pluginClassInputStreamProvider, classLoader, protectionDomain, classNode, skipCode);
    }

    private static int getParsingOption(boolean skipCode) {
        if (skipCode) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readStream(String classPath, ClassInputStreamProvider pluginClassInputStreamProvider, ProtectionDomain protectionDomain, ClassLoader classLoader) {
        InputStream in;
        Scanner scanner = ClassScannerFactory.newScanner(protectionDomain);
        if (scanner != null) {
            try {
                InputStream stream = scanner.openStream(classPath);
                if (stream != null) {
                    try {
                        byte[] byArray = IOUtils.toByteArray((InputStream)stream);
                        return byArray;
                    }
                    catch (IOException e) {
                        logger.warn("bytecode read fail scanner:{} path:{}", (Object)scanner, (Object)classPath);
                        byte[] byArray = null;
                        scanner.close();
                        return byArray;
                    }
                }
            }
            finally {
                scanner.close();
            }
        }
        if ((in = pluginClassInputStreamProvider.getResourceAsStream(classLoader, classPath)) != null) {
            try {
                return IOUtils.toByteArray((InputStream)in);
            }
            catch (IOException e) {
                logger.warn("bytecode read fail path:{}", (Object)classPath);
                return null;
            }
        }
        return null;
    }

    public ASMClassNodeAdapter(ClassInputStreamProvider pluginInputStreamProvider, ClassLoader classLoader, ProtectionDomain protectionDomain, ClassNode classNode) {
        this(pluginInputStreamProvider, classLoader, protectionDomain, classNode, false);
    }

    public ASMClassNodeAdapter(ClassInputStreamProvider pluginInputStreamProvider, ClassLoader classLoader, ProtectionDomain protectionDomain, ClassNode classNode, boolean skipCode) {
        this.pluginInputStreamProvider = pluginInputStreamProvider;
        this.classLoader = classLoader;
        this.protectionDomain = protectionDomain;
        this.classNode = classNode;
        this.skipCode = skipCode;
    }

    public String getInternalName() {
        return this.classNode.name;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    public String getName() {
        return this.classNode.name == null ? null : JavaAssistUtils.jvmNameToJavaName(this.classNode.name);
    }

    public String getSuperClassInternalName() {
        return this.classNode.superName;
    }

    public String getSuperClassName() {
        return this.classNode.superName == null ? null : JavaAssistUtils.jvmNameToJavaName(this.classNode.superName);
    }

    public boolean isInterface() {
        return (this.classNode.access & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.classNode.access & 0x2000) != 0;
    }

    public String[] getInterfaceNames() {
        List interfaces = this.classNode.interfaces;
        if (CollectionUtils.isEmpty((Collection)interfaces)) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(interfaces.size());
        for (String name : interfaces) {
            if (name == null) continue;
            list.add(JavaAssistUtils.jvmNameToJavaName(name));
        }
        return list.toArray(new String[0]);
    }

    public ASMMethodNodeAdapter getDeclaredMethod(String methodName, String desc) {
        if (this.skipCode) {
            throw new IllegalStateException("not supported operation, skipCode option is true.");
        }
        return this.findDeclaredMethod(methodName, desc);
    }

    public List<ASMMethodNodeAdapter> getDeclaredConstructors() {
        if (this.skipCode) {
            throw new IllegalStateException("not supported operation, skipCode option is true.");
        }
        return this.findDeclaredMethod("<init>");
    }

    public boolean hasDeclaredMethod(String methodName, String desc) {
        return this.findDeclaredMethod(methodName, desc) != null;
    }

    private ASMMethodNodeAdapter findDeclaredMethod(String methodName, String desc) {
        Objects.requireNonNull(methodName, "methodName");
        List declaredMethods = this.classNode.methods;
        if (CollectionUtils.isEmpty((Collection)declaredMethods)) {
            return null;
        }
        for (MethodNode methodNode : declaredMethods) {
            if (!StringMatchUtils.equals(methodNode.name, methodName) || desc != null && !StringMatchUtils.startWith(methodNode.desc, desc)) continue;
            return new ASMMethodNodeAdapter(this.getInternalName(), methodNode);
        }
        return null;
    }

    private List<ASMMethodNodeAdapter> findDeclaredMethod(String methodName) {
        Objects.requireNonNull(methodName, "methodName");
        List declaredMethods = this.classNode.methods;
        if (CollectionUtils.isEmpty((Collection)declaredMethods)) {
            return Collections.emptyList();
        }
        ArrayList<ASMMethodNodeAdapter> methodNodes = new ArrayList<ASMMethodNodeAdapter>();
        for (MethodNode methodNode : declaredMethods) {
            if (!StringMatchUtils.equals(methodNode.name, methodName)) continue;
            methodNodes.add(new ASMMethodNodeAdapter(this.getInternalName(), methodNode));
        }
        return methodNodes;
    }

    public List<ASMMethodNodeAdapter> getDeclaredMethods() {
        if (this.skipCode) {
            throw new IllegalStateException("not supported operation, skipCode option is true.");
        }
        List methods = this.classNode.methods;
        if (CollectionUtils.isEmpty((Collection)methods)) {
            return Collections.emptyList();
        }
        ArrayList<ASMMethodNodeAdapter> methodNodes = new ArrayList<ASMMethodNodeAdapter>(methods.size());
        for (MethodNode methodNode : methods) {
            String methodName = methodNode.name;
            if (methodName == null || methodName.equals("<init>") || methodName.equals("<clinit>")) continue;
            methodNodes.add(new ASMMethodNodeAdapter(this.getInternalName(), methodNode));
        }
        return methodNodes;
    }

    public boolean hasOutClass(String methodName, String desc) {
        if (methodName == null || this.classNode.outerClass == null || this.classNode.outerMethod == null || !this.classNode.outerMethod.equals(methodName)) {
            return false;
        }
        if (desc == null) {
            return true;
        }
        return StringMatchUtils.startWith(this.classNode.outerMethodDesc, desc);
    }

    public boolean hasMethod(String methodName, String desc) {
        ASMClassNodeAdapter classNode;
        if (this.hasDeclaredMethod(methodName, desc)) {
            return true;
        }
        if (this.classNode.superName != null && (classNode = ASMClassNodeAdapter.get(this.pluginInputStreamProvider, this.classLoader, this.protectionDomain, this.classNode.superName, true)) != null) {
            return classNode.hasMethod(methodName, desc);
        }
        return false;
    }

    public ASMFieldNodeAdapter getField(String fieldName, String fieldDesc) {
        ASMFieldNodeAdapter fieldNode;
        ASMClassNodeAdapter classNodeAdapter;
        Objects.requireNonNull(fieldName, "fieldName");
        if (this.classNode.fields == null) {
            return null;
        }
        List fields = this.classNode.fields;
        for (Object fieldNode2 : fields) {
            if (!StringMatchUtils.equals(((FieldNode)fieldNode2).name, fieldName) || fieldDesc != null && !StringMatchUtils.equals(((FieldNode)fieldNode2).desc, fieldDesc)) continue;
            return new ASMFieldNodeAdapter((FieldNode)fieldNode2);
        }
        List interfaces = this.classNode.interfaces;
        if (CollectionUtils.hasLength((Collection)interfaces)) {
            for (String interfaceClassName : interfaces) {
                ASMFieldNodeAdapter fieldNode3;
                ASMClassNodeAdapter classNodeAdapter2;
                if (interfaceClassName == null || (classNodeAdapter2 = ASMClassNodeAdapter.get(this.pluginInputStreamProvider, this.classLoader, this.protectionDomain, interfaceClassName, true)) == null || (fieldNode3 = classNodeAdapter2.getField(fieldName, fieldDesc)) == null) continue;
                return fieldNode3;
            }
        }
        if (this.classNode.superName != null && (classNodeAdapter = ASMClassNodeAdapter.get(this.pluginInputStreamProvider, this.classLoader, this.protectionDomain, this.classNode.superName, true)) != null && (fieldNode = classNodeAdapter.getField(fieldName, fieldDesc)) != null) {
            return fieldNode;
        }
        return null;
    }

    public ASMFieldNodeAdapter addField(String fieldName, String fieldDesc) {
        Objects.requireNonNull(fieldName, "fieldName");
        Objects.requireNonNull(fieldDesc, "fieldDesc");
        FieldNode fieldNode = new FieldNode(this.getFieldAccessFlags(), fieldName, fieldDesc, null, null);
        this.addFieldNode0(fieldNode);
        return new ASMFieldNodeAdapter(fieldNode);
    }

    private int getFieldAccessFlags() {
        return 130;
    }

    private void addFieldNode0(FieldNode fieldNode) {
        if (this.classNode.fields == null) {
            this.classNode.fields = new ArrayList();
        }
        this.classNode.fields.add(fieldNode);
    }

    public ASMMethodNodeAdapter addDelegatorMethod(ASMMethodNodeAdapter superMethodNode) {
        Objects.requireNonNull(superMethodNode, "superMethodNode");
        String[] exceptions = this.getSuperMethodExceptions(superMethodNode);
        MethodNode rawMethodNode = new MethodNode(superMethodNode.getAccess(), superMethodNode.getName(), superMethodNode.getDesc(), superMethodNode.getSignature(), exceptions);
        ASMMethodNodeAdapter methodNode = new ASMMethodNodeAdapter(this.getInternalName(), rawMethodNode);
        methodNode.addDelegator(superMethodNode.getDeclaringClassInternalName());
        this.addMethodNode0(methodNode.getMethodNode());
        return methodNode;
    }

    private String[] getSuperMethodExceptions(ASMMethodNodeAdapter superMethodNode) {
        List<String> superMethodNodeExceptions = superMethodNode.getExceptions();
        if (superMethodNodeExceptions == null) {
            return null;
        }
        return superMethodNodeExceptions.toArray(new String[0]);
    }

    public void addGetterMethod(String methodName, ASMFieldNodeAdapter fieldNode) {
        Objects.requireNonNull(methodName, "methodName");
        Objects.requireNonNull(fieldNode, "fieldNode");
        String desc = "()" + fieldNode.getDesc();
        MethodNode methodNode = new MethodNode(1, methodName, desc, null, null);
        InsnList instructions = this.getInsnList(methodNode);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.classNode.name, fieldNode.getName(), fieldNode.getDesc()));
        Type type = Type.getType((String)fieldNode.getDesc());
        instructions.add((AbstractInsnNode)new InsnNode(type.getOpcode(172)));
        this.addMethodNode0(methodNode);
    }

    private void addMethodNode0(MethodNode methodNode) {
        if (this.classNode.methods == null) {
            this.classNode.methods = new ArrayList();
        }
        this.classNode.methods.add(methodNode);
    }

    public void addSetterMethod(String methodName, ASMFieldNodeAdapter fieldNode) {
        Objects.requireNonNull(methodName, "methodName");
        Objects.requireNonNull(fieldNode, "fieldNode");
        String desc = "(" + fieldNode.getDesc() + ")V";
        MethodNode methodNode = new MethodNode(1, methodName, desc, null, null);
        InsnList instructions = this.getInsnList(methodNode);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        Type type = Type.getType((String)fieldNode.getDesc());
        instructions.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), 1));
        instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.classNode.name, fieldNode.getName(), fieldNode.getDesc()));
        instructions.add((AbstractInsnNode)new InsnNode(177));
        this.addMethodNode0(methodNode);
    }

    private InsnList getInsnList(MethodNode methodNode) {
        if (methodNode.instructions == null) {
            methodNode.instructions = new InsnList();
        }
        return methodNode.instructions;
    }

    public void addInterface(String interfaceName) {
        Objects.requireNonNull(interfaceName, "interfaceName");
        if (this.classNode.interfaces == null) {
            this.classNode.interfaces = new ArrayList();
        }
        this.classNode.interfaces.add(JavaAssistUtils.javaNameToJvmName(interfaceName));
    }

    public void copyMethod(ASMMethodNodeAdapter methodNode) {
        Objects.requireNonNull(methodNode, "methodNode");
        ASMMethodInsnNodeRemapper.Builder remapBuilder = new ASMMethodInsnNodeRemapper.Builder();
        remapBuilder.addFilter(methodNode.getDeclaringClassInternalName(), null, null);
        remapBuilder.setOwner(this.classNode.name);
        ASMMethodInsnNodeRemapper remapper = remapBuilder.build();
        methodNode.remapMethodInsnNode(remapper);
        methodNode.remapLocalVariables("this", Type.getObjectType((String)this.classNode.name).getDescriptor());
        this.addMethodNode0(methodNode.getMethodNode());
    }

    public boolean hasAnnotation(Class<?> annotationClass) {
        if (annotationClass == null) {
            return false;
        }
        String desc = Type.getDescriptor(annotationClass);
        return this.hasAnnotation(desc, this.classNode.invisibleAnnotations) || this.hasAnnotation(desc, this.classNode.visibleAnnotations);
    }

    private boolean hasAnnotation(String annotationClassDesc, List<AnnotationNode> annotationNodes) {
        if (annotationClassDesc == null) {
            return false;
        }
        if (annotationNodes == null) {
            return false;
        }
        for (AnnotationNode annotation : annotationNodes) {
            if (!StringMatchUtils.equals(annotation.desc, annotationClassDesc)) continue;
            return true;
        }
        return false;
    }

    public boolean subclassOf(String classInternalName) {
        if (classInternalName == null) {
            return false;
        }
        if (classInternalName.equals("java/lang/Object")) {
            return true;
        }
        ASMClassNodeAdapter classNode = this;
        while (classNode != null) {
            if (classInternalName.equals(classNode.getInternalName())) {
                return true;
            }
            String superClassInternalName = classNode.getSuperClassInternalName();
            if (superClassInternalName == null || superClassInternalName.equals("java/lang/Object")) {
                return false;
            }
            classNode = ASMClassNodeAdapter.get(this.pluginInputStreamProvider, this.classLoader, this.protectionDomain, superClassInternalName, true);
        }
        return false;
    }

    public List<ASMClassNodeAdapter> getInnerClasses() {
        if (this.classNode.innerClasses == null) {
            return Collections.emptyList();
        }
        ArrayList<ASMClassNodeAdapter> innerClasses = new ArrayList<ASMClassNodeAdapter>();
        List innerClassNodes = this.classNode.innerClasses;
        for (InnerClassNode node : innerClassNodes) {
            ASMClassNodeAdapter adapter;
            if (node.name == null || (adapter = ASMClassNodeAdapter.get(this.pluginInputStreamProvider, this.classLoader, this.protectionDomain, node.name, true)) == null) continue;
            innerClasses.add(adapter);
        }
        return innerClasses;
    }

    public int getMajorVersion() {
        int majorVersion = this.classNode.version & 0xFFFF;
        return majorVersion;
    }

    public byte[] toByteArray() {
        int majorVersion = this.classNode.version & 0xFFFF;
        int flags = 2;
        if (majorVersion <= 49) {
            flags = 1;
        }
        ASMClassWriter classWriter = new ASMClassWriter(this.pluginInputStreamProvider, flags, this.classLoader);
        this.classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }
}

