/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.interceptor.Interceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.registry.InterceptorRegistry;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.profiler.context.DefaultMethodDescriptor;
import com.navercorp.pinpoint.profiler.instrument.ASMClass;
import com.navercorp.pinpoint.profiler.instrument.ASMInterceptorHolder;
import com.navercorp.pinpoint.profiler.instrument.ASMMethodNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.EngineComponent;
import com.navercorp.pinpoint.profiler.instrument.ScopeFactory;
import com.navercorp.pinpoint.profiler.instrument.ScopeInfo;
import com.navercorp.pinpoint.profiler.instrument.interceptor.CaptureType;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinition;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorType;
import com.navercorp.pinpoint.profiler.interceptor.factory.AnnotatedInterceptorFactory;
import com.navercorp.pinpoint.profiler.objectfactory.ObjectBinderFactory;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.MethodNode;

public class ASMMethod
implements InstrumentMethod {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final EngineComponent engineComponent;
    private final InstrumentContext pluginContext;
    private final ASMClass declaringClass;
    private final ASMMethodNodeAdapter methodNode;
    private final MethodDescriptor descriptor;

    public ASMMethod(EngineComponent engineComponent, InstrumentContext pluginContext, ASMClass declaringClass, MethodNode methodNode) {
        this(engineComponent, pluginContext, declaringClass, new ASMMethodNodeAdapter(JavaAssistUtils.javaNameToJvmName(declaringClass.getName()), methodNode));
    }

    public ASMMethod(EngineComponent engineComponent, InstrumentContext pluginContext, ASMClass declaringClass, ASMMethodNodeAdapter methodNode) {
        this.engineComponent = Objects.requireNonNull(engineComponent, "engineComponent");
        this.pluginContext = Objects.requireNonNull(pluginContext, "pluginContext");
        this.declaringClass = declaringClass;
        this.methodNode = methodNode;
        String[] parameterVariableNames = this.methodNode.getParameterNames();
        int lineNumber = this.methodNode.getLineNumber();
        this.descriptor = new DefaultMethodDescriptor(declaringClass.getName(), methodNode.getName(), this.getParameterTypes(), parameterVariableNames, lineNumber);
    }

    public String getName() {
        return this.methodNode.getName();
    }

    public String[] getParameterTypes() {
        return this.methodNode.getParameterTypes();
    }

    public String getReturnType() {
        return this.methodNode.getReturnType();
    }

    public int getModifiers() {
        return this.methodNode.getAccess();
    }

    public boolean isConstructor() {
        return this.methodNode.isConstructor();
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class<? extends Interceptor> loadInterceptorClass(String interceptorClassName) throws InstrumentException {
        try {
            ClassLoader classLoader = this.declaringClass.getClassLoader();
            return this.pluginContext.injectClass(classLoader, interceptorClassName);
        }
        catch (Exception ex) {
            throw new InstrumentException(interceptorClassName + " not found Caused by:" + ex.getMessage(), (Throwable)ex);
        }
    }

    public int addInterceptor(Class<? extends Interceptor> interceptorClass) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        int interceptorId = this.newInterceptor(interceptorClass, null, null, null);
        this.addInterceptor0(interceptorClass, interceptorId);
        return interceptorId;
    }

    public int addInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(constructorArgs, "constructorArgs");
        int interceptorId = this.newInterceptor(interceptorClass, constructorArgs, null, null);
        this.addInterceptor0(interceptorClass, interceptorId);
        return interceptorId;
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, String scopeName) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(scopeName, "scopeName");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        int interceptor = this.newInterceptor(interceptorClass, null, interceptorScope, null);
        this.addInterceptor0(interceptorClass, interceptor);
        return interceptor;
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, InterceptorScope interceptorScope) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(interceptorScope, "interceptorScope");
        int interceptorId = this.newInterceptor(interceptorClass, null, interceptorScope, null);
        this.addInterceptor0(interceptorClass, interceptorId);
        return interceptorId;
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(scopeName, "scopeName");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        int interceptorId = this.newInterceptor(interceptorClass, null, interceptorScope, executionPolicy);
        this.addInterceptor0(interceptorClass, interceptorId);
        return interceptorId;
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, InterceptorScope interceptorScope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(interceptorScope, "interceptorScope");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        int interceptorId = this.newInterceptor(interceptorClass, null, interceptorScope, executionPolicy);
        this.addInterceptor0(interceptorClass, interceptorId);
        return interceptorId;
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, String scopeName) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(constructorArgs, "constructorArgs");
        Objects.requireNonNull(scopeName, "scopeName");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        int interceptorId = this.newInterceptor(interceptorClass, constructorArgs, interceptorScope, null);
        this.addInterceptor0(interceptorClass, interceptorId);
        return interceptorId;
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, InterceptorScope interceptorScope) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(constructorArgs, "constructorArgs");
        Objects.requireNonNull(interceptorScope, "interceptorScope");
        int interceptorId = this.newInterceptor(interceptorClass, constructorArgs, interceptorScope, null);
        this.addInterceptor0(interceptorClass, interceptorId);
        return interceptorId;
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, String scopeName, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(constructorArgs, "constructorArgs");
        Objects.requireNonNull(scopeName, "scopeName");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        InterceptorScope interceptorScope = this.pluginContext.getInterceptorScope(scopeName);
        int interceptorId = this.newInterceptor(interceptorClass, constructorArgs, interceptorScope, executionPolicy);
        this.addInterceptor0(interceptorClass, interceptorId);
        return interceptorId;
    }

    public int addScopedInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, InterceptorScope interceptorScope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        Objects.requireNonNull(constructorArgs, "constructorArgs");
        Objects.requireNonNull(interceptorScope, "interceptorScope");
        Objects.requireNonNull(executionPolicy, "executionPolicy");
        int interceptorId = this.newInterceptor(interceptorClass, constructorArgs, interceptorScope, executionPolicy);
        this.addInterceptor0(interceptorClass, interceptorId);
        return interceptorId;
    }

    public void addInterceptor(int interceptorId) throws InstrumentException {
        if (InterceptorRegistry.isInterceptorHolderEnable()) {
            ASMInterceptorHolder holder = new ASMInterceptorHolder(interceptorId);
            Class<? extends Interceptor> interceptorClass = holder.loadInterceptorClass(this.declaringClass.getClassLoader());
            this.addInterceptor0(interceptorClass, interceptorId);
        } else {
            Interceptor interceptor = InterceptorRegistry.getInterceptor((int)interceptorId);
            if (interceptor == null) {
                throw new InstrumentException("not found interceptor " + interceptorId + " to " + this.methodNode.getLongName());
            }
            try {
                this.addInterceptor0(interceptor.getClass(), interceptorId);
            }
            catch (Exception e) {
                throw new InstrumentException("add interceptor0 " + interceptor.getClass().getName() + " to " + this.methodNode.getLongName(), (Throwable)e);
            }
        }
    }

    int addInterceptorInternal(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, InterceptorScope interceptorScope, ExecutionPolicy executionPolicy) throws InstrumentException {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        int interceptorId = this.newInterceptor(interceptorClass, constructorArgs, interceptorScope, executionPolicy);
        this.addInterceptor0(interceptorClass, interceptorId);
        return interceptorId;
    }

    private int newInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, InterceptorScope interceptorScope, ExecutionPolicy executionPolicy) throws InstrumentException {
        ScopeFactory scopeFactory = this.engineComponent.getScopeFactory();
        ScopeInfo scopeInfo = scopeFactory.newScopeInfo(this.pluginContext, interceptorClass, interceptorScope, executionPolicy);
        return this.createInterceptor(interceptorClass, constructorArgs, scopeInfo);
    }

    private int createInterceptor(Class<? extends Interceptor> interceptorClass, Object[] constructorArgs, ScopeInfo scopeInfo) throws InstrumentException {
        ObjectBinderFactory objectBinderFactory = this.engineComponent.getObjectBinderFactory();
        AnnotatedInterceptorFactory factory = objectBinderFactory.newAnnotatedInterceptorFactory(this.pluginContext);
        ClassLoader classLoader = this.declaringClass.getClassLoader();
        int interceptorId = 0;
        if (classLoader == null || Boolean.FALSE == InterceptorRegistry.isInterceptorHolderEnable()) {
            Interceptor interceptor = factory.newInterceptor(interceptorClass, constructorArgs, scopeInfo, this.descriptor);
            interceptorId = this.engineComponent.addInterceptor(interceptor);
        } else {
            interceptorId = this.engineComponent.addInterceptor();
            ASMInterceptorHolder.create(interceptorId, this.declaringClass.getClassLoader(), factory, interceptorClass, constructorArgs, scopeInfo, this.descriptor);
        }
        return interceptorId;
    }

    private void addInterceptor0(Class<? extends Interceptor> interceptorClass, int interceptorId) {
        Objects.requireNonNull(interceptorClass, "interceptorClass");
        InterceptorDefinition interceptorDefinition = this.engineComponent.createInterceptorDefinition(interceptorClass);
        CaptureType captureType = interceptorDefinition.getCaptureType();
        if (this.methodNode.hasInterceptor()) {
            this.logger.warn("Skip adding interceptor. 'already intercepted method' class={}, interceptor={}", (Object)this.declaringClass.getName(), (Object)interceptorClass.getName());
            return;
        }
        if (this.methodNode.isAbstract() || this.methodNode.isNative()) {
            this.logger.info("Skip adding interceptor. 'abstract or native method' class={}, interceptor={}", (Object)this.declaringClass.getName(), (Object)interceptorClass.getName());
            return;
        }
        int apiId = 0;
        if (interceptorDefinition.getInterceptorType() == InterceptorType.API_ID_AWARE) {
            apiId = this.engineComponent.cacheApi(this.descriptor);
        }
        if (this.isBeforeInterceptor(captureType) && interceptorDefinition.getBeforeMethod() != null) {
            this.methodNode.addBeforeInterceptor(interceptorId, interceptorDefinition, apiId);
            this.declaringClass.setModified(true);
        } else if (this.isDebug) {
            this.logger.debug("Skip adding before interceptorDefinition because the interceptorDefinition doesn't have before method: {}", (Object)interceptorClass.getName());
        }
        if (this.isAfterInterceptor(captureType) && interceptorDefinition.getAfterMethod() != null) {
            this.methodNode.addAfterInterceptor(interceptorId, interceptorDefinition, apiId);
            this.declaringClass.setModified(true);
        } else if (this.isDebug) {
            this.logger.debug("Skip adding after interceptor because the interceptor doesn't have after method: {}", (Object)interceptorClass.getName());
        }
    }

    private boolean isBeforeInterceptor(CaptureType captureType) {
        return CaptureType.BEFORE == captureType || CaptureType.AROUND == captureType;
    }

    private boolean isAfterInterceptor(CaptureType captureType) {
        return CaptureType.AFTER == captureType || CaptureType.AROUND == captureType;
    }
}

