/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classreading;

import com.navercorp.pinpoint.profiler.instrument.classreading.InternalClassMetadata;
import java.util.Collections;
import java.util.List;

public class DefaultInternalClassMetadata
implements InternalClassMetadata {
    private final String classInternalName;
    private final String superClassInternalName;
    private final List<String> interfaceInternalNames;
    private final List<String> annotationInternalNames;
    private final boolean isInterface;
    private final boolean isAnnotation;
    private final boolean isSynthetic;
    private final boolean isInnerClass;

    public DefaultInternalClassMetadata(String classInternalName, String superClassInternalName, List<String> interfaceInternalNames, List<String> annotationInternalNames, boolean isInterface, boolean isAnnotation, boolean isSynthetic, boolean isInnerClass) {
        this.classInternalName = classInternalName;
        this.superClassInternalName = superClassInternalName;
        this.interfaceInternalNames = this.defaultInterfaceName(interfaceInternalNames);
        this.annotationInternalNames = this.defaultAnnotationName(annotationInternalNames);
        this.isInterface = isInterface;
        this.isAnnotation = isAnnotation;
        this.isSynthetic = isSynthetic;
        this.isInnerClass = isInnerClass;
    }

    private List<String> defaultInterfaceName(List<String> interfaceInternalNames) {
        if (interfaceInternalNames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(interfaceInternalNames);
    }

    private List<String> defaultAnnotationName(List<String> annotationInternalNames) {
        if (annotationInternalNames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(annotationInternalNames);
    }

    @Override
    public String getClassInternalName() {
        return this.classInternalName;
    }

    @Override
    public String getSuperClassInternalName() {
        return this.superClassInternalName;
    }

    @Override
    public List<String> getInterfaceInternalNames() {
        return this.interfaceInternalNames;
    }

    @Override
    public List<String> getAnnotationInternalNames() {
        return this.annotationInternalNames;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    @Override
    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    @Override
    public boolean isInnerClass() {
        return this.isInnerClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("classInternalName='").append(this.classInternalName).append('\'');
        sb.append(", superClassInternalName='").append(this.superClassInternalName).append('\'');
        sb.append(", interfaceInternalNames=").append(this.interfaceInternalNames);
        sb.append(", annotationInternalNames=").append(this.annotationInternalNames);
        sb.append(", isInterface=").append(this.isInterface);
        sb.append(", isAnnotation=").append(this.isAnnotation);
        sb.append(", isSynthetic=").append(this.isSynthetic);
        sb.append(", isInnerClass=").append(this.isInnerClass);
        sb.append('}');
        return sb.toString();
    }
}

