/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.scanner;

import com.navercorp.pinpoint.common.util.CodeSourceUtils;
import com.navercorp.pinpoint.profiler.instrument.scanner.ClassLoaderScanner;
import com.navercorp.pinpoint.profiler.instrument.scanner.DirectoryScanner;
import com.navercorp.pinpoint.profiler.instrument.scanner.JarFileScanner;
import com.navercorp.pinpoint.profiler.instrument.scanner.Scanner;
import java.net.URL;
import java.security.ProtectionDomain;

public class ClassScannerFactory {
    private static final String FORCE_CLASS_LOADER_SCANNER_PROPERTY_KEY = "pinpoint.force.classloader.scanner";
    private static final boolean FORCE_CLASS_LOADER_SCANNER = ClassScannerFactory.forceClassLoaderScanner();
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_SEPARATOR = "!/";
    private static final String[] FILE_PROTOCOLS = new String[]{"file", "vfs", "jar"};
    private static final String[] JAR_EXTENSIONS = new String[]{".jar", ".war", ".ear"};

    public static Scanner newScanner(ProtectionDomain protectionDomain, ClassLoader classLoader) {
        ClassLoader protectionDomainClassLoader;
        URL codeLocation = CodeSourceUtils.getCodeLocation((ProtectionDomain)protectionDomain);
        if (codeLocation == null) {
            return new ClassLoaderScanner(classLoader);
        }
        Scanner scanner = ClassScannerFactory.newURLScanner(codeLocation);
        if (scanner != null) {
            return scanner;
        }
        if ((FORCE_CLASS_LOADER_SCANNER || ClassScannerFactory.isNestedJar(codeLocation.getPath())) && (protectionDomainClassLoader = protectionDomain.getClassLoader()) != null) {
            return new ClassLoaderScanner(protectionDomainClassLoader);
        }
        throw new IllegalArgumentException("unknown scanner type classLoader:" + classLoader + " protectionDomain:" + protectionDomain);
    }

    public static Scanner newScanner(ProtectionDomain protectionDomain) {
        URL codeLocation = CodeSourceUtils.getCodeLocation((ProtectionDomain)protectionDomain);
        if (codeLocation == null) {
            return null;
        }
        Scanner scanner = ClassScannerFactory.newURLScanner(codeLocation);
        if (scanner != null) {
            return scanner;
        }
        return null;
    }

    private static Scanner newURLScanner(URL codeLocation) {
        String protocol = codeLocation.getProtocol();
        if (ClassScannerFactory.isFileProtocol(protocol)) {
            String path = ClassScannerFactory.cleanupPath(codeLocation.getPath());
            boolean isJarFile = ClassScannerFactory.isJarExtension(path);
            if (isJarFile) {
                return new JarFileScanner(path);
            }
            boolean isDirectory = path.endsWith("/");
            if (isDirectory) {
                return new DirectoryScanner(path);
            }
        }
        return null;
    }

    private static String cleanupPath(String path) {
        int index = path.indexOf(JAR_URL_SEPARATOR);
        if (index == -1) {
            return path;
        }
        if (path.startsWith(FILE_URL_PREFIX)) {
            return path.substring(FILE_URL_PREFIX.length(), index);
        }
        return path.substring(0, index);
    }

    static boolean isJarExtension(String path) {
        if (path == null) {
            return false;
        }
        for (String extension : JAR_EXTENSIONS) {
            if (!path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    static boolean isFileProtocol(String protocol) {
        for (String fileProtocol : FILE_PROTOCOLS) {
            if (!fileProtocol.equals(protocol)) continue;
            return true;
        }
        return false;
    }

    static boolean isNestedJar(String path) {
        if (path == null) {
            return false;
        }
        String separator = JAR_URL_SEPARATOR;
        if (!path.endsWith(JAR_URL_SEPARATOR)) {
            return false;
        }
        String subPath = path.substring(0, path.lastIndexOf(JAR_URL_SEPARATOR));
        return subPath.contains(JAR_URL_SEPARATOR);
    }

    private static boolean forceClassLoaderScanner() {
        String forceClassLoaderScanner = System.getProperty(FORCE_CLASS_LOADER_SCANNER_PROPERTY_KEY);
        return Boolean.parseBoolean(forceClassLoaderScanner);
    }
}

