/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.transformer;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugTransformer
implements ClassFileTransformer {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final InstrumentContext instrumentContext;
    private final InstrumentEngine instrumentEngine;

    public DebugTransformer(InstrumentEngine instrumentEngine, InstrumentContext instrumentContext) {
        this.instrumentEngine = Objects.requireNonNull(instrumentEngine, "instrumentEngine");
        this.instrumentContext = Objects.requireNonNull(instrumentContext, "instrumentContext");
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            InstrumentClass target = this.instrumentEngine.getClass(this.instrumentContext, loader, className, protectionDomain, classfileBuffer);
            if (target == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("targetClass not found. className:{}, classBeingRedefined:{} :{} ", (Object)className, classBeingRedefined, (Object)loader);
                }
                return null;
            }
            if (!target.isInterceptable()) {
                return null;
            }
            for (InstrumentMethod method : target.getDeclaredMethods(MethodFilters.ACCEPT_ALL)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("### c={}, m={}, params={}", (Object)className, (Object)method.getName(), (Object)Arrays.toString(method.getParameterTypes()));
                }
                method.addInterceptor(BasicMethodInterceptor.class);
            }
            return target.toBytecode();
        }
        catch (InstrumentException e) {
            this.logger.warn("Failed to instrument " + className, (Throwable)e);
            return null;
        }
    }
}

