/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.jdbc;

import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.profiler.jdbc.Converter;

public class BytesConverter
implements Converter {
    protected final int maxWidth;

    public BytesConverter(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    @Override
    public String convert(Object[] args) {
        if (args == null) {
            return "null";
        }
        if (args.length == 2) {
            byte[] bytes = (byte[])args[1];
            if (bytes == null) {
                return "null";
            }
            return this.convert(bytes);
        }
        return "error";
    }

    public String convert(Object value) {
        if (value == null) {
            return "null";
        }
        byte[] bytes = (byte[])value;
        return this.convert(bytes);
    }

    protected String convert(byte[] bytes) {
        return ArrayUtils.abbreviate((byte[])bytes, (int)this.maxWidth);
    }
}

