/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor;

import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class StatMonitorJob
implements Runnable {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final Runnable[] runnableList;

    public StatMonitorJob(List<Runnable> runnableList) {
        Objects.requireNonNull(runnableList, "runnableList");
        this.runnableList = runnableList.toArray(new Runnable[0]);
    }

    @Override
    public void run() {
        if (this.isDebug) {
            this.logger.debug("StatMonitorJob started. jobSize={}", (Object)this.runnableList.length);
        }
        for (Runnable runnable : this.runnableList) {
            runnable.run();
        }
    }

    public void close() {
        for (Runnable runnable : this.runnableList) {
            if (!(runnable instanceof Closeable)) continue;
            try {
                ((Closeable)((Object)runnable)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

