/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.profiler.plugin.ClassNameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginPackageClassRequirementFilter
implements ClassNameFilter {
    private final String[] packages;
    private final String[] requirements;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public PluginPackageClassRequirementFilter(List<String> packageRequirementList) {
        Objects.requireNonNull(packageRequirementList, "packageRequirementList");
        ArrayList<String> packageList = new ArrayList<String>();
        ArrayList<String> requirementList = new ArrayList<String>();
        this.parseRequirementList(packageRequirementList, packageList, requirementList);
        this.packages = packageList.toArray(new String[0]);
        this.requirements = requirementList.toArray(new String[0]);
    }

    @Override
    public boolean accept(String className, ClassLoader classLoader) {
        Objects.requireNonNull(classLoader, "classLoader");
        for (int i = 0; i < this.packages.length; ++i) {
            if (!className.startsWith(this.packages[i]) || this.isLoadedClass(this.requirements[i], classLoader)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("reject class:{}, packageName:{}, requirement:{}, classloader:{}", (Object)className, (Object)this.packages[i], (Object)this.requirements[i], (Object)classLoader);
            }
            return false;
        }
        return true;
    }

    private boolean isLoadedClass(String classname, ClassLoader cl) {
        try {
            Class.forName(classname, false, cl);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private void parseRequirementList(List<String> packageRequirementList, List<String> packageList, List<String> requirementList) {
        for (String packageWithRequirement : packageRequirementList) {
            String[] split = packageWithRequirement.split(":", 2);
            if (split.length != 2) continue;
            packageList.add(split[0]);
            requirementList.add(split[1]);
        }
    }

    public String toString() {
        return "PluginPackageRequirementFilter{packages=" + Arrays.toString(this.packages) + ", requirements=" + Arrays.toString(this.requirements) + '}';
    }
}

