/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin.filter;

import com.navercorp.pinpoint.profiler.plugin.PluginJar;
import com.navercorp.pinpoint.profiler.plugin.filter.PluginFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisabledPluginFilter
implements PluginFilter {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Set<String> disabledPluginIds;

    public DisabledPluginFilter(List<String> disabledPluginIds) {
        Objects.requireNonNull(disabledPluginIds, "disabledPluginIds");
        this.disabledPluginIds = new HashSet<String>(disabledPluginIds);
    }

    @Override
    public boolean accept(PluginJar pluginJar) {
        String pluginId = pluginJar.getPluginId();
        if (this.disabledPluginIds.contains(pluginId)) {
            this.logger.info("Skipping disabled plugin : {}", (Object)pluginId);
            return false;
        }
        return true;
    }

    public String toString() {
        return "DisabledPluginFilter{disabledPluginIds=" + this.disabledPluginIds + '}';
    }
}

