/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sampler;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.sampler.Sampler;
import com.navercorp.pinpoint.profiler.sampler.CountingSampler;
import com.navercorp.pinpoint.profiler.sampler.FalseSampler;
import com.navercorp.pinpoint.profiler.sampler.SamplerFactory;
import com.navercorp.pinpoint.profiler.sampler.TrueSampler;

public class CountingSamplerFactory
implements SamplerFactory {
    public static final String LEGACY_SAMPLING_RATE_NAME = "profiler.sampling.rate";
    public static final String SAMPLING_RATE_NAME = "profiler.sampling.counting.sampling-rate";
    private final int samplingRate;

    public CountingSamplerFactory(int samplingRate) {
        this.samplingRate = samplingRate;
    }

    public CountingSamplerFactory(Config config) {
        this(config.getSamplingRate());
    }

    @Override
    public Sampler createSampler() {
        if (this.samplingRate <= 0) {
            return FalseSampler.INSTANCE;
        }
        if (this.samplingRate == 1) {
            return TrueSampler.INSTANCE;
        }
        return new CountingSampler(this.samplingRate);
    }

    public String toString() {
        return "CountingSamplerFactory{samplingRate=" + this.samplingRate + '}';
    }

    public static Config config(ProfilerConfig profilerConfig) {
        int samplingRate = CountingSamplerFactory.getSamplingRate(profilerConfig);
        return new Config(samplingRate);
    }

    private static int getSamplingRate(ProfilerConfig profilerConfig) {
        int legacy = profilerConfig.readInt(LEGACY_SAMPLING_RATE_NAME, -1);
        if (legacy != -1) {
            return legacy;
        }
        return profilerConfig.readInt(SAMPLING_RATE_NAME, 1);
    }

    public static class Config {
        private final int samplingRate;

        public Config(int samplingRate) {
            this.samplingRate = samplingRate;
        }

        public int getSamplingRate() {
            return this.samplingRate;
        }

        public String toString() {
            return "Config{samplingRate=" + this.samplingRate + '}';
        }
    }
}

