/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sampler;

import com.navercorp.pinpoint.bootstrap.sampler.TraceSampler;
import com.navercorp.pinpoint.bootstrap.util.AntPathMatcher;
import com.navercorp.pinpoint.bootstrap.util.EqualsPathMatcher;
import com.navercorp.pinpoint.bootstrap.util.PathMatcher;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class UrlTraceSampler
implements TraceSampler {
    private final UrlPathMatcher[] urlPathMatcherList;
    private final TraceSampler defaultTraceSampler;

    public UrlTraceSampler(Map<String, TraceSampler> urlMap, TraceSampler defaultTraceSampler) {
        Objects.requireNonNull(urlMap, "urlMap");
        this.defaultTraceSampler = Objects.requireNonNull(defaultTraceSampler, "defaultSampler");
        ArrayList<UrlPathMatcher> list = new ArrayList<UrlPathMatcher>();
        for (Map.Entry<String, TraceSampler> entry : urlMap.entrySet()) {
            String urlPath = entry.getKey();
            TraceSampler traceSampler = entry.getValue();
            if (StringUtils.isEmpty((String)urlPath) || traceSampler == null) continue;
            list.add(new UrlPathMatcher(urlPath, traceSampler));
        }
        this.urlPathMatcherList = list.toArray(new UrlPathMatcher[0]);
    }

    public TraceSampler.State isNewSampled() {
        return this.defaultTraceSampler.isNewSampled();
    }

    public TraceSampler.State isNewSampled(String urlPath) {
        TraceSampler traceSampler;
        if (Boolean.FALSE == StringUtils.isEmpty((String)urlPath) && (traceSampler = this.getSampler(urlPath)) != null) {
            return traceSampler.isNewSampled();
        }
        return this.defaultTraceSampler.isNewSampled();
    }

    public TraceSampler.State isContinueSampled() {
        return this.defaultTraceSampler.isContinueSampled();
    }

    public TraceSampler.State getContinueDisableState() {
        return this.defaultTraceSampler.getContinueDisableState();
    }

    TraceSampler getSampler(String urlPath) {
        for (UrlPathMatcher urlPathMatcher : this.urlPathMatcherList) {
            if (urlPathMatcher == null || !urlPathMatcher.isMatched(urlPath) || urlPathMatcher.getTraceSampler() == null) continue;
            return urlPathMatcher.getTraceSampler();
        }
        return this.defaultTraceSampler;
    }

    private static class UrlPathMatcher
    implements PathMatcher {
        private final PathMatcher pathMatcher;
        private final TraceSampler traceSampler;

        public UrlPathMatcher(String urlPath, TraceSampler traceSampler) {
            this.pathMatcher = AntPathMatcher.isAntStylePattern((String)urlPath) ? new AntPathMatcher(urlPath) : new EqualsPathMatcher(urlPath);
            this.traceSampler = traceSampler;
        }

        public boolean isMatched(String urlPath) {
            return this.pathMatcher.isMatched(urlPath);
        }

        public TraceSampler getTraceSampler() {
            return this.traceSampler;
        }
    }
}

