/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.common.profiler.concurrent.ExecutorFactory;
import com.navercorp.pinpoint.common.profiler.concurrent.PinpointThreadFactory;
import com.navercorp.pinpoint.common.profiler.logging.ThrottledLogger;
import com.navercorp.pinpoint.common.profiler.message.DataSender;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.grpc.ExecutorUtils;
import com.navercorp.pinpoint.grpc.ManagedChannelUtils;
import com.navercorp.pinpoint.grpc.client.ChannelFactory;
import io.grpc.Channel;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GrpcDataSender<T>
implements DataSender<T> {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    protected final boolean isDebug = this.logger.isDebugEnabled();
    protected final String name;
    protected final String host;
    protected final int port;
    protected final ManagedChannel managedChannel;
    protected final long logId;
    protected final MessageConverter<T, GeneratedMessageV3> messageConverter;
    protected final ExecutorService executor;
    protected final ChannelFactory channelFactory;
    protected volatile boolean shutdown;
    protected final BlockingQueue<T> queue;
    protected final ThrottledLogger tLogger;

    public GrpcDataSender(String host, int port, int executorQueueSize, MessageConverter<T, GeneratedMessageV3> messageConverter, ChannelFactory channelFactory) {
        this.channelFactory = Objects.requireNonNull(channelFactory, "channelFactory");
        this.name = Objects.requireNonNull(channelFactory.getFactoryName(), "channelFactory.name");
        this.host = Objects.requireNonNull(host, "host");
        this.port = port;
        this.messageConverter = Objects.requireNonNull(messageConverter, "messageConverter");
        this.executor = this.newExecutorService(this.name + "-Executor", executorQueueSize);
        this.managedChannel = channelFactory.build(host, port);
        this.logId = ManagedChannelUtils.getLogId((Channel)this.managedChannel);
        ConnectivityState state = this.managedChannel.getState(false);
        this.managedChannel.notifyWhenStateChanged(state, (Runnable)new ConnectivityStateMonitor(state));
        this.tLogger = ThrottledLogger.getLogger((Logger)this.logger, (long)100L);
        this.queue = new LinkedBlockingQueue<T>(executorQueueSize);
    }

    public long getLogId() {
        return this.logId;
    }

    protected ExecutorService newExecutorService(String name, int senderExecutorQueueSize) {
        PinpointThreadFactory threadFactory = new PinpointThreadFactory("Pinpoint-" + name, true);
        return ExecutorFactory.newFixedThreadPool((int)1, (int)senderExecutorQueueSize, (ThreadFactory)threadFactory);
    }

    public boolean send(T data) {
        if (this.queue.offer(data)) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("reject message queue size:{}", (Object)this.queue.size());
        } else if (this.tLogger.isInfoEnabled()) {
            this.tLogger.info("reject message queue size : {}", (Object)this.queue.size());
        }
        return false;
    }

    protected void release() {
        ChannelFactory channelFactory;
        ExecutorUtils.shutdownExecutorService((String)this.name, (ExecutorService)this.executor);
        ManagedChannel managedChannel = this.managedChannel;
        if (managedChannel != null) {
            ManagedChannelUtils.shutdownManagedChannel((String)this.name, (ManagedChannel)managedChannel);
        }
        if ((channelFactory = this.channelFactory) != null) {
            channelFactory.close();
        }
    }

    private class ConnectivityStateMonitor
    implements Runnable {
        private final ConnectivityState before;

        public ConnectivityStateMonitor(ConnectivityState before) {
            this.before = Objects.requireNonNull(before, "before");
        }

        @Override
        public void run() {
            ConnectivityState change = GrpcDataSender.this.managedChannel.getState(false);
            GrpcDataSender.this.logger.info("ConnectivityState changed before:{}, change:{}", (Object)this.before, (Object)change);
            if (change == ConnectivityState.TRANSIENT_FAILURE) {
                GrpcDataSender.this.logger.info("Failed to connect to collector server {} {}/{}", (Object)GrpcDataSender.this.name, (Object)GrpcDataSender.this.host, (Object)GrpcDataSender.this.port);
            }
            GrpcDataSender.this.managedChannel.notifyWhenStateChanged(change, (Runnable)new ConnectivityStateMonitor(change));
        }
    }
}

