/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.navercorp.pinpoint.grpc.StatusError;
import com.navercorp.pinpoint.grpc.StatusErrors;
import com.navercorp.pinpoint.profiler.sender.grpc.StreamEventListener;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResponseStreamObserver<ReqT, ResT>
implements ClientResponseObserver<ReqT, ResT> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final StreamEventListener<ReqT> listener;

    public ResponseStreamObserver(StreamEventListener<ReqT> listener) {
        this.listener = Objects.requireNonNull(listener, "listener");
    }

    public void beforeStart(final ClientCallStreamObserver<ReqT> requestStream) {
        this.logger.info("beforeStart {}", this.listener);
        requestStream.setOnReadyHandler(new Runnable(){
            private final AtomicLong isReadyCounter = new AtomicLong(0L);

            @Override
            public void run() {
                long isReadyCount = this.isReadyCounter.incrementAndGet();
                ResponseStreamObserver.this.logger.info("onReadyHandler {} isReadyCount:{}", (Object)ResponseStreamObserver.this.listener, (Object)isReadyCount);
                if (isReadyCount == 1L) {
                    ResponseStreamObserver.this.listener.start(requestStream);
                }
            }
        });
    }

    public void onNext(ResT value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} onNext:{}", this.listener, value);
        }
    }

    public void onError(Throwable t) {
        StatusError statusError = StatusErrors.throwable((Throwable)t);
        if (statusError.isSimpleError()) {
            this.logger.info("Failed to stream, name={}, cause={}", this.listener, (Object)statusError.getMessage());
        } else {
            this.logger.info("Failed to stream, name={}, cause={}", this.listener, (Object)statusError.getMessage(), (Object)statusError.getThrowable());
        }
        this.listener.onError(t);
    }

    public void onCompleted() {
        this.logger.info("{} onCompleted", this.listener);
        this.listener.onCompleted();
    }

    public String toString() {
        return "ResponseStreamObserver{name=" + this.listener + '}';
    }
}

