/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.navercorp.pinpoint.grpc.StatusError;
import com.navercorp.pinpoint.grpc.StatusErrors;
import com.navercorp.pinpoint.profiler.sender.grpc.RetryScheduler;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import org.apache.logging.log4j.Logger;

public class RetryResponseStreamObserver<ReqT, ResT>
implements StreamObserver<ResT> {
    private final Logger logger;
    private final RetryScheduler<ReqT, ResT> retryScheduler;
    private final ReqT message;
    private final int remainingRetryCount;

    public RetryResponseStreamObserver(Logger logger, RetryScheduler<ReqT, ResT> retryScheduler, ReqT message, int remainingRetryCount) {
        this.logger = Objects.requireNonNull(logger, "logger");
        this.retryScheduler = Objects.requireNonNull(retryScheduler, "retryScheduler");
        this.message = Objects.requireNonNull(message, "message");
        this.remainingRetryCount = remainingRetryCount;
    }

    public void onNext(ResT response) {
        if (this.retryScheduler.isSuccess(response)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Request success. request={}, result={}", (Object)this.logString(this.message), (Object)this.logString(response));
            }
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Request fail. request={}, result={}", (Object)this.logString(this.message), (Object)this.logString(response));
            }
            this.retryScheduler.scheduleNextRetry(this.message, this.nextRetryCount());
        }
    }

    public void onError(Throwable throwable) {
        StatusError statusError = StatusErrors.throwable((Throwable)throwable);
        if (statusError.isSimpleError()) {
            this.logger.info("Error. request={}, cause={}", (Object)this.logString(this.message), (Object)statusError.getMessage());
        } else {
            this.logger.info("Error. request={}, cause={}", (Object)this.logString(this.message), (Object)statusError.getMessage(), (Object)statusError.getThrowable());
        }
        int remainingRetryCount = this.nextRetryCount();
        this.retryScheduler.scheduleNextRetry(this.message, remainingRetryCount);
    }

    public void onCompleted() {
    }

    private int nextRetryCount() {
        return this.remainingRetryCount - 1;
    }

    private String logString(Object message) {
        if (message == null) {
            return "NULL";
        }
        if (message instanceof GeneratedMessageV3) {
            GeneratedMessageV3 messageV3 = (GeneratedMessageV3)message;
            return TextFormat.shortDebugString((MessageOrBuilder)messageV3);
        }
        return message.toString();
    }
}

