/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util.queue;

import com.navercorp.pinpoint.profiler.util.queue.ObjectArrayIterator;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.RandomAccess;

public class ArrayViewList<E>
extends AbstractList<E>
implements RandomAccess,
Serializable {
    private final E[] array;
    private final int endIndex;

    public ArrayViewList(E[] array, int endIndex) {
        if (endIndex > array.length) {
            throw new ArrayIndexOutOfBoundsException("End index must not be greater than the array length");
        }
        this.array = Objects.requireNonNull(array);
        this.endIndex = endIndex;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.endIndex;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.array, this.endIndex);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            return Arrays.copyOf(this.array, size, a.getClass());
        }
        System.arraycopy(this.array, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public E get(int index) {
        if (index > this.endIndex) {
            throw new ArrayIndexOutOfBoundsException("End index must not be greater than the array length");
        }
        return this.array[index];
    }

    @Override
    public E set(int index, E element) {
        if (index > this.endIndex) {
            throw new ArrayIndexOutOfBoundsException("End index must not be greater than the array length");
        }
        E old = this.array[index];
        this.array[index] = element;
        return old;
    }

    @Override
    public int indexOf(Object element) {
        E[] copy = this.array;
        if (element == null) {
            for (int i = 0; i < this.endIndex; ++i) {
                if (copy[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.endIndex; ++i) {
                if (!element.equals(copy[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new ObjectArrayIterator<E>(this.array, this.endIndex);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public void sort(Comparator<? super E> c) {
        Arrays.sort(this.array, 0, this.endIndex, c);
    }
}

