/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.admin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.apache.eventmesh.webhook.api.WebHookOperationConstant;
import org.apache.eventmesh.webhook.api.common.SharedLatchHolder;
import org.apache.eventmesh.webhook.api.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWebHookConfigOperation
implements WebHookConfigOperation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileWebHookConfigOperation.class);
    private final transient String webHookFilePath;

    public FileWebHookConfigOperation(Properties properties) throws FileNotFoundException {
        String webHookFilePath = WebHookOperationConstant.getFilePath((String)properties.getProperty("filePath"));
        File webHookFileDir = new File(webHookFilePath);
        if (!webHookFileDir.exists()) {
            webHookFileDir.mkdirs();
        }
        if (!webHookFileDir.isDirectory()) {
            throw new FileNotFoundException("File path " + webHookFilePath + " is not directory");
        }
        this.webHookFilePath = webHookFilePath;
    }

    public Integer insertWebHookConfig(WebHookConfig webHookConfig) {
        File webhookConfigFile;
        if (!webHookConfig.getCallbackPath().startsWith("/webhook")) {
            log.error("webhookConfig callback path must start with {}", (Object)"/webhook");
            return 0;
        }
        File manuDir = new File(this.getWebhookConfigManuDir(webHookConfig));
        if (!manuDir.exists()) {
            manuDir.mkdir();
        }
        if ((webhookConfigFile = this.getWebhookConfigFile(webHookConfig)).exists()) {
            log.error("webhookConfig {} exists", (Object)webHookConfig.getCallbackPath());
            return 0;
        }
        return FileWebHookConfigOperation.writeToFile(webhookConfigFile, webHookConfig) ? 1 : 0;
    }

    public Integer updateWebHookConfig(WebHookConfig webHookConfig) {
        File webhookConfigFile = this.getWebhookConfigFile(webHookConfig);
        if (!webhookConfigFile.exists()) {
            log.error("webhookConfig {} does not exist", (Object)webHookConfig.getCallbackPath());
            return 0;
        }
        return FileWebHookConfigOperation.writeToFile(webhookConfigFile, webHookConfig) ? 1 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer deleteWebHookConfig(WebHookConfig webHookConfig) {
        Object object = SharedLatchHolder.lock;
        synchronized (object) {
            File webhookConfigFile = this.getWebhookConfigFile(webHookConfig);
            if (!webhookConfigFile.exists()) {
                log.error("webhookConfig {} does not exist", (Object)webHookConfig.getCallbackPath());
                return 0;
            }
            return webhookConfigFile.delete() ? 1 : 0;
        }
    }

    public WebHookConfig queryWebHookConfigById(WebHookConfig webHookConfig) {
        File webhookConfigFile = this.getWebhookConfigFile(webHookConfig);
        if (!webhookConfigFile.exists()) {
            log.error("webhookConfig {} does not exist", (Object)webHookConfig.getCallbackPath());
            return null;
        }
        return this.getWebHookConfigFromFile(webhookConfigFile);
    }

    public List<WebHookConfig> queryWebHookConfigByManufacturer(WebHookConfig webHookConfig, Integer pageNum, Integer pageSize) {
        String manuDirPath = this.getWebhookConfigManuDir(webHookConfig);
        File manuDir = new File(manuDirPath);
        if (!manuDir.exists()) {
            log.warn("webhookConfig dir {} does not exist", (Object)manuDirPath);
            return new ArrayList<WebHookConfig>();
        }
        ArrayList<WebHookConfig> webHookConfigs = new ArrayList<WebHookConfig>();
        File[] webhookFiles = manuDir.listFiles();
        if (webhookFiles == null || webhookFiles.length == 0) {
            return webHookConfigs;
        }
        int startIndex = (pageNum - 1) * pageSize;
        int endIndex = pageNum * pageSize - 1;
        if (webhookFiles.length > startIndex) {
            for (int i = startIndex; i <= endIndex && i < webhookFiles.length; ++i) {
                webHookConfigs.add(this.getWebHookConfigFromFile(webhookFiles[i]));
            }
        }
        return webHookConfigs;
    }

    private WebHookConfig getWebHookConfigFromFile(File webhookConfigFile) {
        StringBuilder fileContent = new StringBuilder();
        try (BufferedReader br = Files.newBufferedReader(Paths.get(webhookConfigFile.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8);){
            String line;
            while ((line = br.readLine()) != null) {
                fileContent.append(line);
            }
        }
        catch (IOException e) {
            log.error("get webHookConfig from file {} error", (Object)webhookConfigFile.getPath(), (Object)e);
            return null;
        }
        return (WebHookConfig)JsonUtils.parseObject((String)fileContent.toString(), WebHookConfig.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToFile(File webhookConfigFile, WebHookConfig webHookConfig) {
        Object object = SharedLatchHolder.lock;
        synchronized (object) {
            try (FileOutputStream fos = new FileOutputStream(webhookConfigFile);
                 BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));){
                fos.getChannel().lock();
                bw.write(Objects.requireNonNull(JsonUtils.toJSONString((Object)webHookConfig)));
            }
            catch (IOException e) {
                log.error("write webhookConfig {} to file error", (Object)webHookConfig.getCallbackPath());
                return false;
            }
            return true;
        }
    }

    private String getWebhookConfigManuDir(WebHookConfig webHookConfig) {
        return this.webHookFilePath + WebHookOperationConstant.FILE_SEPARATOR + webHookConfig.getManufacturerName();
    }

    private File getWebhookConfigFile(WebHookConfig webHookConfig) {
        String webhookConfigFilePath = this.getWebhookConfigManuDir(webHookConfig) + WebHookOperationConstant.FILE_SEPARATOR + ClassUtils.convertResourcePathToClassName((String)webHookConfig.getCallbackPath());
        return new File(webhookConfigFilePath);
    }
}

