/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.jaeger;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.trace.api.AbstractTraceService;
import org.apache.eventmesh.trace.api.exception.TraceException;
import org.apache.eventmesh.trace.jaeger.config.JaegerConfiguration;

@Config.Configs(value={@Config(field="jaegerConfiguration"), @Config(field="exporterConfiguration")})
public class JaegerTraceService
extends AbstractTraceService {
    private transient JaegerConfiguration jaegerConfiguration;

    public void init() throws TraceException {
        String eventMeshJaegerIp = this.jaegerConfiguration.getEventMeshJaegerIp();
        int eventMeshJaegerPort = this.jaegerConfiguration.getEventMeshJaegerPort();
        int eventMeshTraceExportInterval = this.exporterConfiguration.getEventMeshTraceExportInterval();
        int eventMeshTraceExportTimeout = this.exporterConfiguration.getEventMeshTraceExportTimeout();
        int eventMeshTraceMaxExportSize = this.exporterConfiguration.getEventMeshTraceMaxExportSize();
        int eventMeshTraceMaxQueueSize = this.exporterConfiguration.getEventMeshTraceMaxQueueSize();
        String httpEndpoint = String.format("http://%s:%s", eventMeshJaegerIp, eventMeshJaegerPort);
        JaegerGrpcSpanExporter jaegerExporter = JaegerGrpcSpanExporter.builder().setEndpoint(httpEndpoint).build();
        BatchSpanProcessor spanProcessor = BatchSpanProcessor.builder((SpanExporter)jaegerExporter).setScheduleDelay((long)eventMeshTraceExportInterval, TimeUnit.SECONDS).setExporterTimeout((long)eventMeshTraceExportTimeout, TimeUnit.SECONDS).setMaxExportBatchSize(eventMeshTraceMaxExportSize).setMaxQueueSize(eventMeshTraceMaxQueueSize).build();
        Resource serviceNameResource = Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)"service.name"), (Object)"eventmesh_trace"));
        this.initVars((SpanProcessor)spanProcessor, serviceNameResource);
    }

    public JaegerConfiguration getClientConfiguration() {
        return this.jaegerConfiguration;
    }

    @Generated
    public JaegerConfiguration getJaegerConfiguration() {
        return this.jaegerConfiguration;
    }

    @Generated
    public void setJaegerConfiguration(JaegerConfiguration jaegerConfiguration) {
        this.jaegerConfiguration = jaegerConfiguration;
    }
}

