/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.watch;

import io.etcd.jetcd.AbstractResponse;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.api.Event;
import io.etcd.jetcd.watch.WatchEvent;
import java.util.List;
import java.util.stream.Collectors;

public class WatchResponse
extends AbstractResponse<io.etcd.jetcd.api.WatchResponse> {
    private List<WatchEvent> events;

    public WatchResponse(io.etcd.jetcd.api.WatchResponse response) {
        super(response, response.getHeader());
    }

    private static WatchEvent toEvent(Event event) {
        WatchEvent.EventType eventType;
        switch (event.getType()) {
            case DELETE: {
                eventType = WatchEvent.EventType.DELETE;
                break;
            }
            case PUT: {
                eventType = WatchEvent.EventType.PUT;
                break;
            }
            default: {
                eventType = WatchEvent.EventType.UNRECOGNIZED;
            }
        }
        return new WatchEvent(new KeyValue(event.getKv()), new KeyValue(event.getPrevKv()), eventType);
    }

    public synchronized List<WatchEvent> getEvents() {
        if (this.events == null) {
            this.events = ((io.etcd.jetcd.api.WatchResponse)this.getResponse()).getEventsList().stream().map(WatchResponse::toEvent).collect(Collectors.toList());
        }
        return this.events;
    }
}

