/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.listener;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.Factory;

@PublicEvolving
public interface CatalogContext {
    public String getCatalogName();

    public Optional<String> getFactoryIdentifier();

    @Nullable
    public Class<? extends Catalog> getClazz();

    public Configuration getConfiguration();

    public static CatalogContext createContext(final String catalogName, final Catalog catalog) {
        return new CatalogContext(){

            @Override
            public String getCatalogName() {
                return catalogName;
            }

            @Override
            public Optional<String> getFactoryIdentifier() {
                return catalog == null ? Optional.empty() : catalog.getFactory().map(Factory::factoryIdentifier);
            }

            @Override
            @Nullable
            public Class<? extends Catalog> getClazz() {
                return catalog == null ? null : catalog.getClass();
            }

            @Override
            public Configuration getConfiguration() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

