/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.sink;

import java.util.List;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsWritingMetadata;
import org.apache.flink.table.planner.plan.abilities.sink.SinkAbilitySpec;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeName(value="WritingMetadata")
public final class WritingMetadataSpec
implements SinkAbilitySpec {
    public static final String FIELD_NAME_METADATA_KEYS = "metadataKeys";
    public static final String FIELD_NAME_CONSUMED_TYPE = "consumedType";
    @JsonProperty(value="metadataKeys")
    private final List<String> metadataKeys;
    @JsonProperty(value="consumedType")
    private final LogicalType consumedType;

    @JsonCreator
    public WritingMetadataSpec(@JsonProperty(value="metadataKeys") List<String> metadataKeys, @JsonProperty(value="consumedType") LogicalType consumedType) {
        this.metadataKeys = metadataKeys;
        this.consumedType = consumedType;
    }

    @Override
    public void apply(DynamicTableSink tableSink) {
        if (!(tableSink instanceof SupportsWritingMetadata)) {
            throw new TableException(String.format("%s does not support SupportsWritingMetadata.", tableSink.getClass().getName()));
        }
        DataType consumedDataType = TypeConversions.fromLogicalToDataType((LogicalType)this.consumedType);
        ((SupportsWritingMetadata)tableSink).applyWritableMetadata(this.metadataKeys, consumedDataType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WritingMetadataSpec that = (WritingMetadataSpec)o;
        return Objects.equals(this.metadataKeys, that.metadataKeys) && Objects.equals(this.consumedType, that.consumedType);
    }

    public int hashCode() {
        return Objects.hash(this.metadataKeys, this.consumedType);
    }
}

