/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.source;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@JsonTypeName(value="ProjectPushDown")
public final class ProjectPushDownSpec
extends SourceAbilitySpecBase {
    public static final String FIELD_NAME_PROJECTED_FIELDS = "projectedFields";
    @JsonProperty(value="projectedFields")
    private final int[][] projectedFields;

    @JsonCreator
    public ProjectPushDownSpec(@JsonProperty(value="projectedFields") int[][] projectedFields, @JsonProperty(value="producedType") RowType producedType) {
        super(producedType);
        this.projectedFields = (int[][])Preconditions.checkNotNull((Object)projectedFields);
    }

    @Override
    public void apply(DynamicTableSource tableSource, SourceAbilityContext context) {
        if (!(tableSource instanceof SupportsProjectionPushDown)) {
            throw new TableException(String.format("%s does not support SupportsProjectionPushDown.", tableSource.getClass().getName()));
        }
        ((SupportsProjectionPushDown)tableSource).applyProjection(this.projectedFields, DataTypes.of((LogicalType)((LogicalType)this.getProducedType().get())));
    }

    @Override
    public boolean needAdjustFieldReferenceAfterProjection() {
        return false;
    }

    public int[][] getProjectedFields() {
        return this.projectedFields;
    }

    @Override
    public String getDigests(SourceAbilityContext context) {
        List fieldNames = this.getProducedType().orElseThrow(() -> new TableException("Produced data type is not present.")).getFieldNames();
        return String.format("project=[%s]", String.join((CharSequence)", ", fieldNames));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectPushDownSpec that = (ProjectPushDownSpec)o;
        return Arrays.deepEquals((Object[])this.projectedFields, (Object[])that.projectedFields);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.deepHashCode((Object[])this.projectedFields);
        return result;
    }
}

