/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions$;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalOverAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalOverAggregate;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalOverAggregateRule$;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution$;
import org.apache.flink.table.planner.plan.utils.OverAggregateUtil$;
import org.apache.flink.table.planner.plan.utils.PythonUtil$;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001+\ty2\u000b\u001e:fC6\u0004\u0006._:jG\u0006dwJ^3s\u0003\u001e<'/Z4bi\u0016\u0014V\u000f\\3\u000b\u0005\r!\u0011AB:ue\u0016\fWN\u0003\u0002\u0006\r\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\b\u0011\u0005)!/\u001e7fg*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u000f\r|gN^3si*\u00111\u0004H\u0001\u0004e\u0016d'BA\u000f\u0011\u0003\u001d\u0019\u0017\r\\2ji\u0016L!a\b\r\u0003\u001b\r{gN^3si\u0016\u0014(+\u001e7f\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013AB2p]\u001aLw\r\u0005\u0002$g9\u0011A%\r\b\u0003KAr!AJ\u0018\u000f\u0005\u001drcB\u0001\u0015.\u001d\tIC&D\u0001+\u0015\tYC#\u0001\u0004=e>|GOP\u0005\u0002'%\u0011\u0011CE\u0005\u0003;AI!a\u0007\u000f\n\u0005eQ\u0012B\u0001\u001a\u0019\u00035\u0019uN\u001c<feR,'OU;mK&\u0011A'\u000e\u0002\u0007\u0007>tg-[4\u000b\u0005IB\u0002\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\b\u0006\u0002:wA\u0011!\bA\u0007\u0002\u0005!)\u0011E\u000ea\u0001E!)Q\b\u0001C!}\u00059Q.\u0019;dQ\u0016\u001cHCA F!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u001d\u0011un\u001c7fC:DQA\u0012\u001fA\u0002\u001d\u000bAaY1mYB\u0011\u0001JS\u0007\u0002\u0013*\u0011\u0011\u0002H\u0005\u0003\u0017&\u0013aBU3m\u001fB$(+\u001e7f\u0007\u0006dG\u000eC\u0003\u001a\u0001\u0011\u0005S\n\u0006\u0002O%B\u0011q\nU\u0007\u00025%\u0011\u0011K\u0007\u0002\b%\u0016dgj\u001c3f\u0011\u0015YB\n1\u0001O\u000f\u0015!&\u0001#\u0001V\u0003}\u0019FO]3b[BC\u0017p]5dC2|e/\u001a:BO\u001e\u0014XmZ1uKJ+H.\u001a\t\u0003uY3Q!\u0001\u0002\t\u0002]\u001b\"A\u0016-\u0011\u0005\u0001K\u0016B\u0001.B\u0005\u0019\te.\u001f*fM\")qG\u0016C\u00019R\tQ\u000bC\u0004_-\n\u0007I\u0011A0\u0002\u0011%s5\u000bV!O\u0007\u0016+\u0012\u0001\u0019\t\u0003\u0011\u0006L!AY%\u0003\u0015I+Gn\u00149u%VdW\r\u0003\u0004e-\u0002\u0006I\u0001Y\u0001\n\u0013:\u001bF+\u0011(D\u000b\u0002\u0002")
public class StreamPhysicalOverAggregateRule
extends ConverterRule {
    public static RelOptRule INSTANCE() {
        return StreamPhysicalOverAggregateRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalOverAggregate logicWindow = (FlinkLogicalOverAggregate)call.rel(0);
        Buffer agg = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((Window.Group)logicWindow.groups.get(0)).getAggregateCalls(logicWindow)).asScala();
        return !agg.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PythonUtil$.MODULE$.isPythonAggregate(x$1, PythonUtil$.MODULE$.isPythonAggregate$default$2())));
    }

    @Override
    public RelNode convert(RelNode rel) {
        FlinkLogicalOverAggregate logicWindow = (FlinkLogicalOverAggregate)rel;
        if (logicWindow.groups.size() > 1) {
            throw new TableException("Over Agg: Unsupported use of OVER windows. All aggregates must be computed on the same window. please re-check the over window statement.");
        }
        ImmutableBitSet keys = ((Window.Group)logicWindow.groups.get((int)0)).keys;
        FlinkRelDistribution requiredDistribution = !keys.isEmpty() ? FlinkRelDistribution$.MODULE$.hash(keys.asList(), FlinkRelDistribution$.MODULE$.hash$default$2()) : FlinkRelDistribution$.MODULE$.SINGLETON();
        RelTraitSet requiredTraitSet = logicWindow.getInput().getTraitSet().replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL()).replace(requiredDistribution);
        RelTraitSet providedTraitSet = rel.getTraitSet().replace(FlinkConventions$.MODULE$.STREAM_PHYSICAL());
        RelNode input = logicWindow.getInput();
        RelNode newInput = RelOptRule.convert(input, requiredTraitSet);
        RelDataType outputRowType = OverAggregateUtil$.MODULE$.inferOutputRowType(logicWindow.getCluster(), input.getRowType(), (Seq<AggregateCall>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(((Window.Group)logicWindow.groups.get(0)).getAggregateCalls(logicWindow)).asScala()));
        return new StreamPhysicalOverAggregate(rel.getCluster(), providedTraitSet, newInput, outputRowType, logicWindow);
    }

    public StreamPhysicalOverAggregateRule(ConverterRule.Config config) {
        super(config);
    }
}

