/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput.input;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.table.runtime.operators.multipleinput.TableOperatorWrapper;
import org.apache.flink.table.runtime.operators.multipleinput.input.InputSelectionSpec;
import org.apache.flink.util.Preconditions;

public class InputSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InputSelectionSpec inputSelectionSpec;
    private final TableOperatorWrapper<?> output;
    private final int outputOpInputId;

    public InputSpec(int multipleInputId, int readOrder, TableOperatorWrapper<?> output, int outputOpInputId) {
        this.inputSelectionSpec = new InputSelectionSpec(multipleInputId, readOrder);
        this.output = (TableOperatorWrapper)Preconditions.checkNotNull(output);
        this.outputOpInputId = outputOpInputId;
    }

    public InputSelectionSpec getInputSelectionSpec() {
        return this.inputSelectionSpec;
    }

    public int getMultipleInputId() {
        return this.inputSelectionSpec.getMultipleInputId();
    }

    public int getReadOrder() {
        return this.inputSelectionSpec.getReadOrder();
    }

    public TableOperatorWrapper<?> getOutput() {
        return this.output;
    }

    public int getOutputOpInputId() {
        return this.outputOpInputId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputSpec inputSpec = (InputSpec)o;
        return this.outputOpInputId == inputSpec.outputOpInputId && Objects.equals(this.inputSelectionSpec, inputSpec.inputSelectionSpec) && Objects.equals(this.output, inputSpec.output);
    }

    public int hashCode() {
        return Objects.hash(this.inputSelectionSpec, this.output, this.outputOpInputId);
    }

    public String toString() {
        return "InputSpec{inputSelectionSpec=" + this.inputSelectionSpec + ", output=" + this.output + ", outputOpInputId=" + this.outputOpInputId + "}";
    }
}

