/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor.operator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.CheckpointListener;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.compactor.IdenticalFileCompactor;
import org.apache.flink.connector.file.sink.compactor.operator.CompactService;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorOperator;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorRequest;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorRequestSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.CommittableSummary;
import org.apache.flink.streaming.api.connector.sink2.CommittableWithLineage;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.util.SimpleVersionedListState;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.types.Either;
import org.apache.flink.util.Preconditions;

@Internal
public class CompactorOperatorStateHandler
extends AbstractStreamOperator<CommittableMessage<FileSinkCommittable>>
implements OneInputStreamOperator<Either<CommittableMessage<FileSinkCommittable>, CompactorRequest>, CommittableMessage<FileSinkCommittable>>,
BoundedOneInput,
CheckpointListener {
    private final SimpleVersionedSerializer<FileSinkCommittable> committableSerializer;
    private final BucketWriter<?, String> bucketWriter;
    private transient CompactService compactService;
    private final List<Tuple2<CompactorRequest, CompletableFuture<Iterable<FileSinkCommittable>>>> compactingRequests = new LinkedList<Tuple2<CompactorRequest, CompletableFuture<Iterable<FileSinkCommittable>>>>();
    private SimpleVersionedListState<Map<Long, List<CompactorRequest>>> remainingRequestsState;
    private Iterable<Map<Long, List<CompactorRequest>>> stateRemaining;

    public CompactorOperatorStateHandler(StreamOperatorParameters<CommittableMessage<FileSinkCommittable>> parameters, SimpleVersionedSerializer<FileSinkCommittable> committableSerializer, BucketWriter<?, String> bucketWriter) {
        super(parameters);
        this.committableSerializer = committableSerializer;
        this.bucketWriter = bucketWriter;
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.remainingRequestsState = new SimpleVersionedListState(context.getOperatorStateStore().getListState(CompactorOperator.REMAINING_REQUESTS_RAW_STATES_DESC), (SimpleVersionedSerializer)new CompactorOperator.RemainingRequestsSerializer(new CompactorRequestSerializer(this.committableSerializer)));
        this.stateRemaining = this.remainingRequestsState.get();
    }

    public void open() throws Exception {
        super.open();
        this.compactService = new CompactService(1, new IdenticalFileCompactor(), this.bucketWriter);
        this.compactService.open();
        if (this.stateRemaining != null) {
            for (Map<Long, List<CompactorRequest>> requests : this.stateRemaining) {
                for (Map.Entry<Long, List<CompactorRequest>> e : requests.entrySet()) {
                    for (CompactorRequest request : e.getValue()) {
                        List<FileSinkCommittable> toCompactList = request.getCommittableToCompact();
                        List<FileSinkCommittable> toPassThrough = request.getCommittableToPassthrough();
                        String bucketId = request.getBucketId();
                        for (FileSinkCommittable toCompact : toCompactList) {
                            CompactorRequest compactRequest = new CompactorRequest(bucketId);
                            compactRequest.addToCompact(toCompact);
                            this.compactingRequests.add((Tuple2<CompactorRequest, CompletableFuture<Iterable<FileSinkCommittable>>>)new Tuple2((Object)compactRequest, this.submit(compactRequest)));
                        }
                        CompactorRequest passThroughRequest = new CompactorRequest(bucketId);
                        toPassThrough.forEach(passThroughRequest::addToPassthrough);
                        this.compactingRequests.add((Tuple2<CompactorRequest, CompletableFuture<Iterable<FileSinkCommittable>>>)new Tuple2((Object)passThroughRequest, this.submit(passThroughRequest)));
                    }
                }
            }
        }
        this.stateRemaining = null;
    }

    public void processElement(StreamRecord<Either<CommittableMessage<FileSinkCommittable>, CompactorRequest>> element) throws Exception {
        Either record = (Either)element.getValue();
        if (record.isLeft()) {
            CommittableMessage message = (CommittableMessage)record.left();
            if (message instanceof CommittableWithLineage) {
                if (this.isHiddenCommittable((CommittableWithLineage<FileSinkCommittable>)((CommittableWithLineage)message))) {
                    this.handleHiddenCommittable((CommittableWithLineage<FileSinkCommittable>)((CommittableWithLineage)message));
                } else {
                    this.output.collect((Object)new StreamRecord((Object)message));
                }
            } else if (this.compactingRequests.isEmpty()) {
                this.output.collect((Object)new StreamRecord((Object)message));
            } else {
                this.appendCompactingResultsToSummary((CommittableSummary<FileSinkCommittable>)((CommittableSummary)message));
            }
        } else {
            CompactorRequest request = (CompactorRequest)((Either)element.getValue()).right();
            this.compactingRequests.add((Tuple2<CompactorRequest, CompletableFuture<Iterable<FileSinkCommittable>>>)new Tuple2((Object)request, this.submit(request)));
        }
    }

    private void appendCompactingResultsToSummary(CommittableSummary<FileSinkCommittable> summary) throws ExecutionException, InterruptedException {
        ArrayList results = new ArrayList();
        for (Tuple2<CompactorRequest, CompletableFuture<Iterable<FileSinkCommittable>>> t : this.compactingRequests) {
            ((Iterable)((CompletableFuture)t.f1).get()).forEach(results::add);
        }
        this.compactingRequests.clear();
        this.output.collect((Object)new StreamRecord((Object)new CommittableSummary(summary.getSubtaskId(), summary.getNumberOfSubtasks(), summary.getCheckpointIdOrEOI(), summary.getNumberOfCommittables() + results.size(), summary.getNumberOfPendingCommittables() + results.size(), summary.getNumberOfFailedCommittables())));
        for (FileSinkCommittable committable : results) {
            this.output.collect((Object)new StreamRecord((Object)new CommittableWithLineage((Object)committable, summary.getCheckpointIdOrEOI(), summary.getSubtaskId())));
        }
    }

    private boolean isHiddenCommittable(CommittableWithLineage<FileSinkCommittable> message) {
        return ((FileSinkCommittable)message.getCommittable()).hasPendingFile() && ((FileSinkCommittable)message.getCommittable()).getPendingFile().getPath() != null && ((FileSinkCommittable)message.getCommittable()).getPendingFile().getPath().getName().startsWith(".");
    }

    private void handleHiddenCommittable(CommittableWithLineage<FileSinkCommittable> message) throws ExecutionException, InterruptedException {
        FileSinkCommittable committable = (FileSinkCommittable)message.getCommittable();
        CompactorRequest request = new CompactorRequest(committable.getBucketId());
        request.addToCompact(committable);
        Iterable<FileSinkCommittable> result = this.submit(request).get();
        Long checkpointId = message.getCheckpointIdOrEOI();
        boolean pendingFileSent = false;
        for (FileSinkCommittable c : result) {
            if (c.hasPendingFile()) {
                Preconditions.checkState((!pendingFileSent ? 1 : 0) != 0, (Object)"A in-progress file should not be converted to multiple pending files");
                pendingFileSent = true;
                this.output.collect((Object)new StreamRecord((Object)new CommittableWithLineage((Object)c, checkpointId.longValue(), message.getSubtaskId())));
                continue;
            }
            CompactorRequest passThroughRequest = new CompactorRequest(c.getBucketId());
            passThroughRequest.addToPassthrough(c);
            this.compactingRequests.add((Tuple2<CompactorRequest, CompletableFuture<Iterable<FileSinkCommittable>>>)new Tuple2((Object)passThroughRequest, this.submit(passThroughRequest)));
        }
    }

    public void endInput() throws Exception {
    }

    public void close() throws Exception {
        super.close();
        if (this.compactService != null) {
            this.compactService.close();
        }
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        if (this.compactingRequests.isEmpty()) {
            return;
        }
        ArrayList<CompactorRequest> remainingRequests = new ArrayList<CompactorRequest>();
        for (Tuple2<CompactorRequest, CompletableFuture<Iterable<FileSinkCommittable>>> t : this.compactingRequests) {
            if (((CompletableFuture)t.f1).isDone()) {
                Iterable result = (Iterable)((CompletableFuture)t.f1).get();
                if (!result.iterator().hasNext()) continue;
                String bucketId = ((FileSinkCommittable)result.iterator().next()).getBucketId();
                CompactorRequest passThroughRequest = new CompactorRequest(bucketId);
                result.forEach(passThroughRequest::addToPassthrough);
                remainingRequests.add(passThroughRequest);
                continue;
            }
            remainingRequests.add((CompactorRequest)t.f0);
        }
        HashMap<Long, ArrayList<CompactorRequest>> requestsMap = new HashMap<Long, ArrayList<CompactorRequest>>();
        requestsMap.put(-1L, remainingRequests);
        this.remainingRequestsState.update(Collections.singletonList(requestsMap));
    }

    private CompletableFuture<Iterable<FileSinkCommittable>> submit(CompactorRequest request) {
        CompletableFuture<Iterable<FileSinkCommittable>> resultFuture = new CompletableFuture<Iterable<FileSinkCommittable>>();
        this.compactService.submit(request, resultFuture);
        return resultFuture;
    }
}

