/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.traces.otel;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Context;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.otel.OpenTelemetryReporterBase;
import org.apache.flink.metrics.otel.OpenTelemetryReporterOptions;
import org.apache.flink.metrics.otel.VariableNameUtil;
import org.apache.flink.traces.Span;
import org.apache.flink.traces.reporter.TraceReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryTraceReporter
extends OpenTelemetryReporterBase
implements TraceReporter {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTelemetryTraceReporter.class);
    private SpanExporter spanExporter;
    private TracerProvider tracerProvider;
    private BatchSpanProcessor spanProcessor;

    @Override
    public void open(MetricConfig metricConfig) {
        LOG.info("Starting OpenTelemetryTraceReporter");
        super.open(metricConfig);
        String protocol = Optional.ofNullable(metricConfig.getProperty(OpenTelemetryReporterOptions.EXPORTER_PROTOCOL.key())).orElse("");
        switch (protocol.toLowerCase()) {
            case "http": {
                OtlpHttpSpanExporterBuilder httpBuilder = OtlpHttpSpanExporter.builder();
                OpenTelemetryReporterOptions.tryConfigureEndpoint(metricConfig, httpBuilder::setEndpoint);
                OpenTelemetryReporterOptions.tryConfigureTimeout(metricConfig, httpBuilder::setTimeout);
                this.spanExporter = httpBuilder.build();
                break;
            }
            default: {
                LOG.warn("Unknown protocol '{}' for OpenTelemetryTraceReporter, defaulting to gRPC", (Object)protocol);
            }
            case "grpc": {
                OtlpGrpcSpanExporterBuilder grpcBuilder = OtlpGrpcSpanExporter.builder();
                OpenTelemetryReporterOptions.tryConfigureEndpoint(metricConfig, grpcBuilder::setEndpoint);
                OpenTelemetryReporterOptions.tryConfigureTimeout(metricConfig, grpcBuilder::setTimeout);
                this.spanExporter = grpcBuilder.build();
            }
        }
        this.spanProcessor = BatchSpanProcessor.builder(this.spanExporter).build();
        this.tracerProvider = SdkTracerProvider.builder().addSpanProcessor(this.spanProcessor).setResource(this.resource).build();
    }

    public void close() {
        if (this.spanProcessor != null) {
            this.spanProcessor.forceFlush();
            this.spanProcessor.close();
        }
        if (this.spanExporter != null) {
            this.spanExporter.flush();
            this.spanExporter.close();
        }
    }

    private void notifyOfAddedSpanInternal(Span span, io.opentelemetry.api.trace.Span parent) {
        Tracer tracer = this.tracerProvider.get(span.getScope());
        SpanBuilder spanBuilder = tracer.spanBuilder(span.getName());
        span.getAttributes().forEach(OpenTelemetryTraceReporter.setAttribute(spanBuilder));
        if (parent == null) {
            spanBuilder.setNoParent();
        } else {
            spanBuilder.setParent(Context.current().with(parent));
        }
        io.opentelemetry.api.trace.Span currentOtelSpan = spanBuilder.setStartTimestamp(span.getStartTsMillis(), TimeUnit.MILLISECONDS).startSpan();
        for (Span childSpan : span.getChildren()) {
            this.notifyOfAddedSpanInternal(childSpan, currentOtelSpan);
        }
        currentOtelSpan.end(span.getEndTsMillis(), TimeUnit.MILLISECONDS);
    }

    private static BiConsumer<String, Object> setAttribute(SpanBuilder spanBuilder) {
        return (key, value) -> {
            key = VariableNameUtil.getVariableName(key);
            if (value instanceof String) {
                spanBuilder.setAttribute((String)key, (String)value);
            } else if (value instanceof Long) {
                spanBuilder.setAttribute((String)key, (Long)value);
            } else if (value instanceof Double) {
                spanBuilder.setAttribute((String)key, (Double)value);
            } else {
                LOG.warn("Unsupported attribute type [{}={}]", key, value);
            }
        };
    }

    public void notifyOfAddedSpan(Span span) {
        this.notifyOfAddedSpanInternal(span, null);
    }
}

