/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.util;

import java.nio.ByteBuffer;

public final class ByteBufferUtils {
    private ByteBufferUtils() {
    }

    public static int totalLength(ByteBuffer[] buffers) {
        int total = 0;
        for (ByteBuffer buffer : buffers) {
            total += buffer.remaining();
        }
        return total;
    }

    public static ByteBuffer aggregate(ByteBuffer[] buffers) {
        if (buffers.length == 1) {
            return buffers[0];
        }
        ByteBuffer aggregate = ByteBuffer.allocate(ByteBufferUtils.totalLength(buffers));
        for (ByteBuffer element : buffers) {
            aggregate.put(element);
        }
        return (ByteBuffer)aggregate.flip();
    }
}

