/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator.webapp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GlobalPolicyGenerator;
import org.apache.hadoop.yarn.server.globalpolicygenerator.webapp.dao.GpgInfo;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/ws/v1/gpg")
public class GPGWebServices {
    private static final Logger LOG = LoggerFactory.getLogger(GPGWebServices.class);
    private GlobalPolicyGenerator gpgGenerator;
    private WebApp webapp;

    @Inject
    public GPGWebServices(GlobalPolicyGenerator gpg, WebApp webapp) {
        this.gpgGenerator = gpg;
        this.webapp = webapp;
    }

    @GET
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public GpgInfo get() {
        return new GpgInfo(this.gpgGenerator.getGPGContext());
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public GpgInfo getGPGInfo() {
        return new GpgInfo(this.gpgGenerator.getGPGContext());
    }
}

