/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.data;

import java.util.Calendar;
import java.util.Date;
import org.ojalgo.finance.data.DataSource;
import org.ojalgo.finance.data.DatePrice;
import org.ojalgo.type.CalendarDateUnit;

public class YahooSymbol
extends DataSource<Data> {
    private static final String CHART_FINANCE_YAHOO_COM = "chart.finance.yahoo.com";
    private static final String CSV = ".csv";
    private static final String D = "d";
    private static final String G = "g";
    private static final String IGNORE = "ignore";
    private static final String M = "m";
    private static final String S = "s";
    private static final String TABLE_CSV = "/table.csv";
    private static final String W = "w";

    public YahooSymbol(String symbol) {
        this(symbol, CalendarDateUnit.DAY);
    }

    public YahooSymbol(String symbol, CalendarDateUnit resolution) {
        super(symbol, resolution);
        this.setHost(CHART_FINANCE_YAHOO_COM);
        this.setPath(TABLE_CSV);
        this.addQueryParameter(S, symbol);
        switch (resolution) {
            case MONTH: {
                this.addQueryParameter(G, M);
                break;
            }
            case WEEK: {
                this.addQueryParameter(G, W);
                break;
            }
            default: {
                this.addQueryParameter(G, D);
            }
        }
        this.addQueryParameter(IGNORE, CSV);
    }

    @Override
    public Data parse(String line) {
        Data retVal = null;
        try {
            int tmpInclusiveBegin = 0;
            int tmpExclusiveEnd = line.indexOf(44, tmpInclusiveBegin);
            String tmpString = line.substring(tmpInclusiveBegin, tmpExclusiveEnd);
            retVal = new Data(tmpString);
            tmpInclusiveBegin = tmpExclusiveEnd + 1;
            tmpExclusiveEnd = line.indexOf(44, tmpInclusiveBegin);
            tmpString = line.substring(tmpInclusiveBegin, tmpExclusiveEnd);
            try {
                retVal.open = Double.parseDouble(tmpString);
            }
            catch (NumberFormatException ex) {
                retVal.open = Double.NaN;
            }
            tmpInclusiveBegin = tmpExclusiveEnd + 1;
            tmpExclusiveEnd = line.indexOf(44, tmpInclusiveBegin);
            tmpString = line.substring(tmpInclusiveBegin, tmpExclusiveEnd);
            try {
                retVal.high = Double.parseDouble(tmpString);
            }
            catch (NumberFormatException ex) {
                retVal.open = Double.NaN;
            }
            tmpInclusiveBegin = tmpExclusiveEnd + 1;
            tmpExclusiveEnd = line.indexOf(44, tmpInclusiveBegin);
            tmpString = line.substring(tmpInclusiveBegin, tmpExclusiveEnd);
            try {
                retVal.low = Double.parseDouble(tmpString);
            }
            catch (NumberFormatException ex) {
                retVal.open = Double.NaN;
            }
            tmpInclusiveBegin = tmpExclusiveEnd + 1;
            tmpExclusiveEnd = line.indexOf(44, tmpInclusiveBegin);
            tmpString = line.substring(tmpInclusiveBegin, tmpExclusiveEnd);
            try {
                retVal.close = Double.parseDouble(tmpString);
            }
            catch (NumberFormatException ex) {
                retVal.open = Double.NaN;
            }
            tmpInclusiveBegin = tmpExclusiveEnd + 1;
            tmpExclusiveEnd = line.indexOf(44, tmpInclusiveBegin);
            tmpString = line.substring(tmpInclusiveBegin, tmpExclusiveEnd);
            try {
                retVal.volume = Double.parseDouble(tmpString);
            }
            catch (NumberFormatException ex) {
                retVal.open = Double.NaN;
            }
            tmpInclusiveBegin = tmpExclusiveEnd + 1;
            tmpString = line.substring(tmpInclusiveBegin);
            try {
                retVal.adjustedClose = Double.parseDouble(tmpString);
            }
            catch (NumberFormatException ex) {
                retVal.open = Double.NaN;
            }
        }
        catch (Exception exception) {
            retVal = null;
        }
        return retVal;
    }

    public static final class Data
    extends DatePrice {
        public double adjustedClose;
        public double close;
        public double high;
        public double low;
        public double open;
        public double volume;

        protected Data(Calendar calendar) {
            super(calendar);
        }

        protected Data(Date date) {
            super(date);
        }

        protected Data(long millis) {
            super(millis);
        }

        protected Data(String sqlString) {
            super(sqlString);
        }

        @Override
        public double getPrice() {
            return this.adjustedClose;
        }
    }
}

