/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.TestStateStoreDriverBase;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreMySQLImpl;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestStateStoreMySQL
extends TestStateStoreDriverBase {
    private static final String CONNECTION_URL = "jdbc:derby:memory:StateStore";

    @BeforeClass
    public static void initDatabase() throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:derby:memory:StateStore;create=true");
        Statement s = connection.createStatement();
        s.execute("CREATE SCHEMA TESTUSER");
        Configuration conf = FederationStateStoreTestUtils.getStateStoreConfiguration(StateStoreMySQLImpl.class);
        conf.set("state-store-mysql.connection.url", CONNECTION_URL);
        conf.set("state-store-mysql.connection.username", "testuser");
        conf.set("state-store-mysql.connection.password", "testpassword");
        conf.set("state-store-mysql.connection.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        TestStateStoreMySQL.getStateStore(conf);
    }

    @Before
    public void startup() throws IOException {
        TestStateStoreMySQL.removeAll(this.getStateStoreDriver());
    }

    @AfterClass
    public static void cleanupDatabase() {
        block2: {
            try {
                DriverManager.getConnection("jdbc:derby:memory:StateStore;drop=true");
            }
            catch (SQLException e) {
                if (e.getMessage().contains("dropped")) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    @Test
    public void testInsert() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testInsert(this.getStateStoreDriver());
    }

    @Test
    public void testUpdate() throws IllegalArgumentException, ReflectiveOperationException, IOException, SecurityException {
        this.testPut(this.getStateStoreDriver());
    }

    @Test
    public void testDelete() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testRemove(this.getStateStoreDriver());
    }

    @Test
    public void testFetchErrors() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testFetchErrors(this.getStateStoreDriver());
    }

    @Test
    public void testMetrics() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testMetrics(this.getStateStoreDriver());
    }
}

