/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.FairSchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;

@XmlRootElement(name="fairScheduler")
@XmlType(name="fairScheduler")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FairSchedulerInfo
extends SchedulerInfo {
    public static final int INVALID_FAIR_SHARE = -1;
    private FairSchedulerQueueInfo rootQueue;
    @XmlTransient
    private FairScheduler scheduler;

    public FairSchedulerInfo() {
    }

    public FairSchedulerInfo(FairScheduler fs) {
        this.scheduler = fs;
        this.rootQueue = new FairSchedulerQueueInfo(this.scheduler.getQueueManager().getRootQueue(), this.scheduler);
        this.schedulerName = "Fair Scheduler";
    }

    public long getAppFairShare(ApplicationAttemptId appAttemptId) {
        FSAppAttempt fsAppAttempt = this.scheduler.getSchedulerApp(appAttemptId);
        return fsAppAttempt == null ? -1L : fsAppAttempt.getFairShare().getMemorySize();
    }

    public FairSchedulerQueueInfo getRootQueueInfo() {
        return this.rootQueue;
    }
}

