/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.AsyncAppender;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestAuditLogs {
    private static final Logger LOG = LoggerFactory.getLogger(TestAuditLogs.class);
    final boolean useAsyncEdits;
    private static GenericTestUtils.LogCapturer auditLogCapture;
    private static final Pattern AUDIT_PATTERN;
    private static final Pattern SUCCESS_PATTERN;
    private static final Pattern FAILURE_PATTERN;
    private static final Pattern WEB_OPEN_PATTERN;
    static final String username = "bob";
    static final String[] groups;
    static final String fileName = "/srcdat";
    DFSTestUtil util;
    MiniDFSCluster cluster;
    FileSystem fs;
    String[] fnames;
    Configuration conf;
    UserGroupInformation userGroupInfo;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{Boolean.FALSE});
        params.add(new Object[]{Boolean.TRUE});
        return params;
    }

    public TestAuditLogs(boolean useAsyncEdits) {
        this.useAsyncEdits = useAsyncEdits;
    }

    @Before
    public void setupCluster() throws Exception {
        this.conf = new HdfsConfiguration();
        long precision = 1L;
        this.conf.setLong("dfs.namenode.accesstime.precision", 1L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.conf.setBoolean("dfs.namenode.edits.asynclogging", this.useAsyncEdits);
        this.util = new DFSTestUtil.Builder().setName("TestAuditAllowed").setNumFiles(20).build();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(4).build();
        this.fs = this.cluster.getFileSystem();
        this.util.createFiles(this.fs, fileName);
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)"org.apache.hadoop.hdfs.server.namenode.FSNamesystem.audit");
        ArrayList appenders = Collections.list(logger.getAllAppenders());
        Assert.assertTrue((boolean)(appenders.get(0) instanceof AsyncAppender));
        this.fnames = this.util.getFileNames(fileName);
        this.util.waitReplication(this.fs, fileName, (short)3);
        this.userGroupInfo = UserGroupInformation.createUserForTesting((String)username, (String[])groups);
    }

    @After
    public void teardownCluster() throws Exception {
        this.util.cleanup(this.fs, fileName);
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @BeforeClass
    public static void beforeClass() {
        auditLogCapture = GenericTestUtils.LogCapturer.captureLogs((Logger)FSNamesystem.AUDIT_LOG);
    }

    @AfterClass
    public static void afterClass() {
        auditLogCapture.stopCapturing();
    }

    @Test
    public void testAuditAllowed() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        FSDataInputStream istream = userfs.open(file);
        int val = istream.read();
        istream.close();
        this.verifySuccessCommandsAuditLogs(2, this.fnames[0], "cmd=open");
        Assert.assertTrue((String)"failed to read from file", (val >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAuditAllowedStat() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        FileStatus st = userfs.getFileStatus(file);
        this.verifySuccessCommandsAuditLogs(2, this.fnames[0], "cmd=getfileinfo");
        Assert.assertTrue((String)"failed to stat file", (st != null && st.isFile() ? 1 : 0) != 0);
    }

    @Test
    public void testAuditDenied() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        this.fs.setPermission(file, new FsPermission(384));
        this.fs.setOwner(file, "root", null);
        try {
            userfs.open(file);
            Assert.fail((String)"open must not succeed");
        }
        catch (AccessControlException e) {
            System.out.println("got access denied, as expected.");
        }
        this.verifyFailedCommandsAuditLogs(1, this.fnames[0], "cmd=open");
    }

    @Test
    public void testAuditWebHdfs() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(420));
        this.fs.setOwner(file, "root", null);
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
        FSDataInputStream istream = webfs.open(file);
        int val = istream.read();
        istream.close();
        this.verifySuccessCommandsAuditLogs(3, this.fnames[0], "cmd=open");
        Assert.assertTrue((String)"failed to read from file", (val >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAuditWebHdfsStat() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(420));
        this.fs.setOwner(file, "root", null);
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
        FileStatus st = webfs.getFileStatus(file);
        this.verifySuccessCommandsAuditLogs(2, this.fnames[0], "cmd=getfileinfo");
        Assert.assertTrue((String)"failed to stat file", (st != null && st.isFile() ? 1 : 0) != 0);
    }

    @Test
    public void testAuditWebHdfsDenied() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(384));
        this.fs.setOwner(file, "root", null);
        try {
            WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
            FSDataInputStream istream = webfs.open(file);
            int val = istream.read();
            Assert.fail((String)("open+read must not succeed, got " + val));
        }
        catch (AccessControlException E) {
            System.out.println("got access denied, as expected.");
        }
        this.verifyFailedCommandsAuditLogs(1, this.fnames[0], "cmd=open");
    }

    @Test
    public void testAuditWebHdfsOpen() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(420));
        this.fs.setOwner(file, "root", null);
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf, "webhdfs");
        webfs.open(file).read();
        this.verifySuccessCommandsAuditLogs(3, this.fnames[0], "cmd=open");
    }

    @Test
    public void testAuditCharacterEscape() throws Exception {
        Path file = new Path("foo\r\nbar");
        this.fs.create(file);
        this.verifySuccessCommandsAuditLogs(1, "foo", "cmd=create");
    }

    private void verifySuccessCommandsAuditLogs(int leastExpected, String file, String cmd) {
        String[] auditLogOutputLines = auditLogCapture.getOutput().split("\\n");
        int success = 0;
        for (String auditLogLine : auditLogOutputLines) {
            if (!auditLogLine.contains("allowed=")) continue;
            String line = "allowed=" + auditLogLine.split("allowed=")[1];
            LOG.info("Line: {}", (Object)line);
            if (!SUCCESS_PATTERN.matcher(line).matches() || !line.contains(file) || !line.contains(cmd)) continue;
            Assert.assertTrue((String)"Expected audit event not found in audit log", (boolean)AUDIT_PATTERN.matcher(line).matches());
            LOG.info("Successful verification. Log line: {}", (Object)line);
            ++success;
        }
        if (success < leastExpected) {
            throw new AssertionError((Object)("Least expected: " + leastExpected + ". Actual success: " + success));
        }
    }

    private void verifyFailedCommandsAuditLogs(int expected, String file, String cmd) {
        String[] auditLogOutputLines = auditLogCapture.getOutput().split("\\n");
        int success = 0;
        for (String auditLogLine : auditLogOutputLines) {
            if (!auditLogLine.contains("allowed=")) continue;
            String line = "allowed=" + auditLogLine.split("allowed=")[1];
            LOG.info("Line: {}", (Object)line);
            if (!FAILURE_PATTERN.matcher(line).matches() || !line.contains(file) || !line.contains(cmd)) continue;
            Assert.assertTrue((String)"Expected audit event not found in audit log", (boolean)AUDIT_PATTERN.matcher(line).matches());
            LOG.info("Failure verification. Log line: {}", (Object)line);
            ++success;
        }
        Assert.assertEquals((String)("Expected: " + expected + ". Actual failure: " + success), (long)expected, (long)success);
    }

    static {
        AUDIT_PATTERN = Pattern.compile("allowed=.*?\\sugi=.*?\\sip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\scmd=.*?\\ssrc=.*?\\sdst=null\\sperm=.*?");
        SUCCESS_PATTERN = Pattern.compile(".*allowed=true.*");
        FAILURE_PATTERN = Pattern.compile(".*allowed=false.*");
        WEB_OPEN_PATTERN = Pattern.compile(".*cmd=open.*proto=webhdfs.*");
        groups = new String[]{"group1"};
    }
}

