/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.primitives.Longs;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MetaCellComparator
extends CellComparatorImpl {
    public static final MetaCellComparator META_COMPARATOR = new MetaCellComparator();

    @Override
    public int compareRows(Cell left, Cell right) {
        if (left instanceof ByteBufferExtendedCell) {
            ByteBufferExtendedCell bbLeft = (ByteBufferExtendedCell)left;
            if (right instanceof ByteBufferExtendedCell) {
                ByteBufferExtendedCell bbRight = (ByteBufferExtendedCell)right;
                return MetaCellComparator.compareBBRows(bbLeft.getRowByteBuffer(), bbLeft.getRowPosition(), left.getRowLength(), bbRight.getRowByteBuffer(), bbRight.getRowPosition(), right.getRowLength());
            }
            return MetaCellComparator.compareBBAndBytesRows(bbLeft.getRowByteBuffer(), bbLeft.getRowPosition(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
        }
        if (right instanceof ByteBufferExtendedCell) {
            ByteBufferExtendedCell bbRight = (ByteBufferExtendedCell)right;
            return -MetaCellComparator.compareBBAndBytesRows(bbRight.getRowByteBuffer(), bbRight.getRowPosition(), right.getRowLength(), left.getRowArray(), left.getRowOffset(), left.getRowLength());
        }
        return MetaCellComparator.compareBytesRows(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
    }

    @Override
    public int compareRows(Cell left, byte[] right, int roffset, int rlength) {
        if (left instanceof ByteBufferExtendedCell) {
            ByteBufferExtendedCell bbLeft = (ByteBufferExtendedCell)left;
            return MetaCellComparator.compareBBAndBytesRows(bbLeft.getRowByteBuffer(), bbLeft.getRowPosition(), left.getRowLength(), right, roffset, rlength);
        }
        return MetaCellComparator.compareBytesRows(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right, roffset, rlength);
    }

    @Override
    public int compareRows(byte[] leftRow, byte[] rightRow) {
        return MetaCellComparator.compareBytesRows(leftRow, 0, leftRow.length, rightRow, 0, rightRow.length);
    }

    @Override
    public int compare(Cell a, Cell b, boolean ignoreSequenceid) {
        int diff = this.compareRows(a, b);
        if (diff != 0) {
            return diff;
        }
        diff = this.compareWithoutRow(a, b);
        if (diff != 0) {
            return diff;
        }
        return ignoreSequenceid ? diff : Longs.compare((long)b.getSequenceId(), (long)a.getSequenceId());
    }

    private static <L, R> int compareRows(L left, int loffset, int llength, R right, int roffset, int rlength, SearchDelimiter<L> searchLeft, SearchDelimiter<R> searchRight, SearchDelimiterInReverse<L> searchInReverseLeft, SearchDelimiterInReverse<R> searchInReverseRight, Compare<L, R> comparator) {
        int rightFarDelimiter;
        int leftFarDelimiter;
        int rightDelimiter;
        int rpart;
        int leftDelimiter = searchLeft.search(left, loffset, llength, 44);
        int lpart = leftDelimiter < 0 ? llength : leftDelimiter - loffset;
        int result = comparator.compareTo(left, loffset, lpart, right, roffset, rpart = (rightDelimiter = searchRight.search(right, roffset, rlength, 44)) < 0 ? rlength : rightDelimiter - roffset);
        if (result != 0) {
            return result;
        }
        if (leftDelimiter < 0 && rightDelimiter >= 0) {
            return -1;
        }
        if (rightDelimiter < 0 && leftDelimiter >= 0) {
            return 1;
        }
        if (leftDelimiter < 0) {
            return 0;
        }
        if ((result = comparator.compareTo(left, leftDelimiter, lpart = ((leftFarDelimiter = searchInReverseLeft.search(left, ++leftDelimiter, llength - (leftDelimiter - loffset), 44)) < 0 ? llength + loffset : leftFarDelimiter) - leftDelimiter, right, rightDelimiter, rpart = ((rightFarDelimiter = searchInReverseRight.search(right, ++rightDelimiter, rlength - (rightDelimiter - roffset), 44)) < 0 ? rlength + roffset : rightFarDelimiter) - rightDelimiter)) != 0) {
            return result;
        }
        if (leftDelimiter < 0 && rightDelimiter >= 0) {
            return -1;
        }
        if (rightDelimiter < 0 && leftDelimiter >= 0) {
            return 1;
        }
        if (leftDelimiter < 0) {
            return 0;
        }
        result = comparator.compareTo(left, ++leftFarDelimiter, llength - (leftFarDelimiter - loffset), right, ++rightFarDelimiter, rlength - (rightFarDelimiter - roffset));
        return result;
    }

    private static int compareBBRows(ByteBuffer left, int loffset, int llength, ByteBuffer right, int roffset, int rlength) {
        if (left.hasArray()) {
            return -MetaCellComparator.compareBBAndBytesRows(right, roffset, rlength, left.array(), left.arrayOffset() + loffset, llength);
        }
        if (right.hasArray()) {
            return MetaCellComparator.compareBBAndBytesRows(left, loffset, llength, right.array(), right.arrayOffset() + roffset, rlength);
        }
        return MetaCellComparator.compareRows(left, loffset, llength, right, roffset, rlength, ByteBufferUtils::searchDelimiterIndex, ByteBufferUtils::searchDelimiterIndex, ByteBufferUtils::searchDelimiterIndexInReverse, ByteBufferUtils::searchDelimiterIndexInReverse, ByteBufferUtils::compareTo);
    }

    private static int compareBBAndBytesRows(ByteBuffer left, int loffset, int llength, byte[] right, int roffset, int rlength) {
        if (left.hasArray()) {
            return MetaCellComparator.compareBytesRows(left.array(), left.arrayOffset() + loffset, llength, right, roffset, rlength);
        }
        return MetaCellComparator.compareRows(left, loffset, llength, right, roffset, rlength, ByteBufferUtils::searchDelimiterIndex, Bytes::searchDelimiterIndex, ByteBufferUtils::searchDelimiterIndexInReverse, Bytes::searchDelimiterIndexInReverse, ByteBufferUtils::compareTo);
    }

    private static int compareBytesRows(byte[] left, int loffset, int llength, byte[] right, int roffset, int rlength) {
        return MetaCellComparator.compareRows(left, loffset, llength, right, roffset, rlength, Bytes::searchDelimiterIndex, Bytes::searchDelimiterIndex, Bytes::searchDelimiterIndexInReverse, Bytes::searchDelimiterIndexInReverse, Bytes::compareTo);
    }

    @Override
    public int compareRows(ByteBuffer row, Cell cell) {
        if (cell instanceof ByteBufferExtendedCell) {
            ByteBufferExtendedCell bbCell = (ByteBufferExtendedCell)cell;
            return MetaCellComparator.compareBBRows(row, row.position(), row.remaining(), bbCell.getRowByteBuffer(), bbCell.getRowPosition(), cell.getRowLength());
        }
        return MetaCellComparator.compareBBAndBytesRows(row, row.position(), row.remaining(), cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    @Override
    public Comparator getSimpleComparator() {
        return this;
    }

    @FunctionalInterface
    private static interface Compare<L, R> {
        public int compareTo(L var1, int var2, int var3, R var4, int var5, int var6);
    }

    @FunctionalInterface
    private static interface SearchDelimiterInReverse<T> {
        public int search(T var1, int var2, int var3, int var4);
    }

    @FunctionalInterface
    private static interface SearchDelimiter<T> {
        public int search(T var1, int var2, int var3, int var4);
    }
}

