/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseServerException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RetryImmediatelyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.client.backoff.HBaseServerExceptionPauseManager;
import org.apache.hadoop.hbase.client.backoff.ServerStatistics;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.io.netty.util.Timer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class AsyncBatchRpcRetryingCaller<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncBatchRpcRetryingCaller.class);
    private final Timer retryTimer;
    private final AsyncConnectionImpl conn;
    private final TableName tableName;
    private final List<Action> actions;
    private final List<CompletableFuture<T>> futures;
    private final IdentityHashMap<Action, CompletableFuture<T>> action2Future;
    private final IdentityHashMap<Action, List<RetriesExhaustedException.ThrowableWithExtraContext>> action2Errors;
    private final int maxAttempts;
    private final long operationTimeoutNs;
    private final long rpcTimeoutNs;
    private final int startLogErrorsCnt;
    private final long startNs;
    private final HBaseServerExceptionPauseManager pauseManager;
    private final Map<String, byte[]> requestAttributes;
    private static final int MAX_SAMPLED_ERRORS = 3;

    public AsyncBatchRpcRetryingCaller(Timer retryTimer, AsyncConnectionImpl conn, TableName tableName, List<? extends Row> actions, long pauseNs, long pauseNsForServerOverloaded, int maxAttempts, long operationTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt, Map<String, byte[]> requestAttributes) {
        this.retryTimer = retryTimer;
        this.conn = conn;
        this.tableName = tableName;
        this.maxAttempts = maxAttempts;
        this.operationTimeoutNs = operationTimeoutNs;
        this.rpcTimeoutNs = rpcTimeoutNs;
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.actions = new ArrayList<Action>(actions.size());
        this.futures = new ArrayList<CompletableFuture<T>>(actions.size());
        this.action2Future = new IdentityHashMap(actions.size());
        this.pauseManager = new HBaseServerExceptionPauseManager(pauseNs, pauseNsForServerOverloaded, operationTimeoutNs);
        int n = actions.size();
        for (int i = 0; i < n; ++i) {
            Row rawAction = actions.get(i);
            Action action = rawAction instanceof OperationWithAttributes ? new Action(rawAction, i, ((OperationWithAttributes)((Object)rawAction)).getPriority()) : new Action(rawAction, i);
            if (AsyncBatchRpcRetryingCaller.hasIncrementOrAppend(rawAction)) {
                action.setNonce(conn.getNonceGenerator().newNonce());
            }
            this.actions.add(action);
            CompletableFuture future = new CompletableFuture();
            this.futures.add(future);
            this.action2Future.put(action, future);
        }
        this.action2Errors = new IdentityHashMap();
        this.startNs = System.nanoTime();
        this.requestAttributes = requestAttributes;
    }

    private static boolean hasIncrementOrAppend(Row action) {
        if (action instanceof Append || action instanceof Increment) {
            return true;
        }
        if (action instanceof RowMutations) {
            return AsyncBatchRpcRetryingCaller.hasIncrementOrAppend((RowMutations)action);
        }
        if (action instanceof CheckAndMutate) {
            return AsyncBatchRpcRetryingCaller.hasIncrementOrAppend(((CheckAndMutate)action).getAction());
        }
        return false;
    }

    private static boolean hasIncrementOrAppend(RowMutations mutations) {
        for (Mutation mutation : mutations.getMutations()) {
            if (!(mutation instanceof Append) && !(mutation instanceof Increment)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RetriesExhaustedException.ThrowableWithExtraContext> removeErrors(Action action) {
        IdentityHashMap<Action, List<RetriesExhaustedException.ThrowableWithExtraContext>> identityHashMap = this.action2Errors;
        synchronized (identityHashMap) {
            return this.action2Errors.remove(action);
        }
    }

    private void logRegionsException(int tries, Supplier<Stream<RegionRequest>> regionsSupplier, Throwable error, ServerName serverName) {
        if (tries > this.startLogErrorsCnt) {
            String regions = regionsSupplier.get().map(r -> "'" + r.loc.getRegion().getRegionNameAsString() + "'").collect(Collectors.joining(",", "[", "]"));
            LOG.warn("Process batch for {} from {} failed, tries={}", new Object[]{regions, serverName, tries, error});
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/(src/test/|AsyncBatchRpcRetryingCaller).*")
    static void logActionsException(int tries, int startLogErrorsCnt, RegionRequest regionReq, IdentityHashMap<Action, Throwable> action2Error, ServerName serverName) {
        if (tries <= startLogErrorsCnt || action2Error.isEmpty()) {
            return;
        }
        if (LOG.isWarnEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter action2ErrorWriter = new PrintWriter(sw);
            action2ErrorWriter.println();
            Iterator<Map.Entry<Action, Throwable>> iter = action2Error.entrySet().iterator();
            for (int i = 0; i < 3 && iter.hasNext(); ++i) {
                Map.Entry<Action, Throwable> entry = iter.next();
                action2ErrorWriter.print(entry.getKey().getAction());
                action2ErrorWriter.print(" => ");
                entry.getValue().printStackTrace(action2ErrorWriter);
            }
            action2ErrorWriter.flush();
            LOG.warn("Process batch for {} on {}, {}/{} actions failed, tries={}, sampled {} errors: {}", new Object[]{regionReq.loc.getRegion().getRegionNameAsString(), serverName, action2Error.size(), regionReq.actions.size(), tries, Math.min(3, action2Error.size()), sw.toString()});
        }
        if (LOG.isTraceEnabled()) {
            action2Error.forEach((action, error) -> LOG.trace("Process action {} in batch for {} on {} failed, tries={}", new Object[]{action.getAction(), regionReq.loc.getRegion().getRegionNameAsString(), serverName, tries, error}));
        }
    }

    private String getExtraContextForError(ServerName serverName) {
        return serverName != null ? serverName.getServerName() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addError(Action action, Throwable error, ServerName serverName) {
        List errors;
        IdentityHashMap<Action, List<RetriesExhaustedException.ThrowableWithExtraContext>> identityHashMap = this.action2Errors;
        synchronized (identityHashMap) {
            errors = this.action2Errors.computeIfAbsent(action, k -> new ArrayList());
        }
        errors.add(new RetriesExhaustedException.ThrowableWithExtraContext(error, EnvironmentEdgeManager.currentTime(), this.getExtraContextForError(serverName)));
    }

    private void addError(Iterable<Action> actions, Throwable error, ServerName serverName) {
        actions.forEach(action -> this.addError((Action)action, error, serverName));
    }

    private void failOne(Action action, int tries, Throwable error, long currentTime, String extras) {
        CompletableFuture<T> future = this.action2Future.get(action);
        if (future.isDone()) {
            return;
        }
        RetriesExhaustedException.ThrowableWithExtraContext errorWithCtx = new RetriesExhaustedException.ThrowableWithExtraContext(error, currentTime, extras);
        List<RetriesExhaustedException.ThrowableWithExtraContext> errors = this.removeErrors(action);
        if (errors == null) {
            errors = Collections.singletonList(errorWithCtx);
        } else {
            errors.add(errorWithCtx);
        }
        future.completeExceptionally(new RetriesExhaustedException(tries - 1, errors));
    }

    private void failAll(Stream<Action> actions, int tries, Throwable error, ServerName serverName) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        String extras = this.getExtraContextForError(serverName);
        actions.forEach(action -> this.failOne((Action)action, tries, error, currentTime, extras));
    }

    private void failAll(Stream<Action> actions, int tries) {
        actions.forEach(action -> {
            CompletableFuture<T> future = this.action2Future.get(action);
            if (future.isDone()) {
                return;
            }
            future.completeExceptionally(new RetriesExhaustedException(tries, Optional.ofNullable(this.removeErrors((Action)action)).orElse(Collections.emptyList())));
        });
    }

    private ClientProtos.MultiRequest buildReq(Map<byte[], RegionRequest> actionsByRegion, List<CellScannable> cells, Map<Integer, Integer> indexMap) throws IOException {
        ClientProtos.MultiRequest.Builder multiRequestBuilder = ClientProtos.MultiRequest.newBuilder();
        ClientProtos.RegionAction.Builder regionActionBuilder = ClientProtos.RegionAction.newBuilder();
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        for (Map.Entry<byte[], RegionRequest> entry : actionsByRegion.entrySet()) {
            long nonceGroup = this.conn.getNonceGenerator().getNonceGroup();
            RequestConverter.buildNoDataRegionActions(entry.getKey(), entry.getValue().actions.stream().sorted((a1, a2) -> Integer.compare(a1.getOriginalIndex(), a2.getOriginalIndex())).collect(Collectors.toList()), cells, multiRequestBuilder, regionActionBuilder, actionBuilder, mutationBuilder, nonceGroup, indexMap);
        }
        return multiRequestBuilder.build();
    }

    private void onComplete(Action action, RegionRequest regionReq, int tries, ServerName serverName, MultiResponse.RegionResult regionResult, List<Action> failedActions, Throwable regionException, MutableBoolean retryImmediately, IdentityHashMap<Action, Throwable> action2Error) {
        Object result = regionResult.result.getOrDefault(action.getOriginalIndex(), regionException);
        if (result == null) {
            LOG.error("Server " + serverName + " sent us neither result nor exception for row '" + Bytes.toStringBinary(action.getAction().getRow()) + "' of " + regionReq.loc.getRegion().getRegionNameAsString());
            this.addError(action, (Throwable)new RuntimeException("Invalid response"), serverName);
            failedActions.add(action);
        } else if (result instanceof Throwable) {
            Throwable error = ConnectionUtils.translateException((Throwable)result);
            action2Error.put(action, error);
            this.conn.getLocator().updateCachedLocationOnError(regionReq.loc, error);
            if (error instanceof DoNotRetryIOException || tries >= this.maxAttempts) {
                this.failOne(action, tries, error, EnvironmentEdgeManager.currentTime(), this.getExtraContextForError(serverName));
            } else {
                if (!retryImmediately.booleanValue() && error instanceof RetryImmediatelyException) {
                    retryImmediately.setTrue();
                }
                failedActions.add(action);
            }
        } else {
            this.action2Future.get(action).complete(result);
        }
    }

    private void onComplete(Map<byte[], RegionRequest> actionsByRegion, int tries, ServerName serverName, MultiResponse resp) {
        ConnectionUtils.updateStats(this.conn.getStatisticsTracker(), this.conn.getConnectionMetrics(), serverName, resp);
        ArrayList failedActions = new ArrayList();
        MutableBoolean retryImmediately = new MutableBoolean(false);
        actionsByRegion.forEach((rn, regionReq) -> {
            MultiResponse.RegionResult regionResult = resp.getResults().get(rn);
            Throwable regionException = resp.getException((byte[])rn);
            if (regionResult != null) {
                IdentityHashMap<Action, Throwable> action2Error = new IdentityHashMap<Action, Throwable>();
                regionReq.actions.forEach(action -> this.onComplete((Action)action, (RegionRequest)regionReq, tries, serverName, regionResult, failedActions, regionException, retryImmediately, action2Error));
                AsyncBatchRpcRetryingCaller.logActionsException(tries, this.startLogErrorsCnt, regionReq, action2Error, serverName);
            } else {
                Throwable error;
                if (regionException == null) {
                    LOG.error("Server sent us neither results nor exceptions for {}", (Object)Bytes.toStringBinary(rn));
                    error = new RuntimeException("Invalid response");
                } else {
                    error = ConnectionUtils.translateException(regionException);
                }
                this.logRegionsException(tries, () -> Stream.of(regionReq), error, serverName);
                this.conn.getLocator().updateCachedLocationOnError(regionReq.loc, error);
                if (error instanceof DoNotRetryIOException || tries >= this.maxAttempts) {
                    this.failAll(regionReq.actions.stream(), tries, error, serverName);
                    return;
                }
                if (!retryImmediately.booleanValue() && error instanceof RetryImmediatelyException) {
                    retryImmediately.setTrue();
                }
                this.addError(regionReq.actions, error, serverName);
                failedActions.addAll(regionReq.actions);
            }
        });
        if (!failedActions.isEmpty()) {
            this.tryResubmit(failedActions.stream(), tries, retryImmediately.booleanValue(), null);
        }
    }

    private void sendToServer(ServerName serverName, ServerRequest serverReq, int tries) {
        ClientProtos.MultiRequest req;
        ClientProtos.ClientService.Interface stub;
        long remainingNs;
        if (this.operationTimeoutNs > 0L) {
            remainingNs = this.pauseManager.remainingTimeNs(this.startNs);
            if (remainingNs <= 0L) {
                this.failAll(serverReq.actionsByRegion.values().stream().flatMap(r -> r.actions.stream()), tries);
                return;
            }
        } else {
            remainingNs = Long.MAX_VALUE;
        }
        try {
            stub = this.conn.getRegionServerStub(serverName);
        }
        catch (IOException e) {
            this.onError(serverReq.actionsByRegion, tries, e, serverName);
            return;
        }
        ArrayList<CellScannable> cells = new ArrayList<CellScannable>();
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        try {
            req = this.buildReq(serverReq.actionsByRegion, cells, indexMap);
        }
        catch (IOException e) {
            this.onError(serverReq.actionsByRegion, tries, e, serverName);
            return;
        }
        HBaseRpcController controller = this.conn.rpcControllerFactory.newController();
        ConnectionUtils.resetController(controller, Math.min(this.rpcTimeoutNs, remainingNs), ConnectionUtils.calcPriority(serverReq.getPriority(), this.tableName), this.tableName);
        controller.setRequestAttributes(this.requestAttributes);
        if (!cells.isEmpty()) {
            controller.setCellScanner(CellUtil.createCellScanner(cells));
        }
        stub.multi(controller, req, resp -> {
            if (controller.failed()) {
                this.onError(serverReq.actionsByRegion, tries, controller.getFailed(), serverName);
            } else {
                try {
                    this.onComplete(serverReq.actionsByRegion, tries, serverName, ResponseConverter.getResults(req, indexMap, resp, controller.cellScanner()));
                }
                catch (Exception e) {
                    this.onError(serverReq.actionsByRegion, tries, e, serverName);
                    return;
                }
            }
        });
    }

    private void sendOrDelay(Map<ServerName, ServerRequest> actionsByServer, int tries) {
        Optional<MetricsConnection> metrics = this.conn.getConnectionMetrics();
        Optional<ServerStatisticTracker> optStats = this.conn.getStatisticsTracker();
        if (!optStats.isPresent()) {
            actionsByServer.forEach((serverName, serverReq) -> {
                metrics.ifPresent(MetricsConnection::incrNormalRunners);
                this.sendToServer((ServerName)serverName, (ServerRequest)serverReq, tries);
            });
            return;
        }
        ServerStatisticTracker stats = optStats.get();
        ClientBackoffPolicy backoffPolicy = this.conn.getBackoffPolicy();
        actionsByServer.forEach((serverName, serverReq) -> {
            ServerStatistics serverStats = stats.getStats((ServerName)serverName);
            HashMap<Long, ServerRequest> groupByBackoff = new HashMap<Long, ServerRequest>();
            serverReq.actionsByRegion.forEach((regionName, regionReq) -> {
                long backoff = backoffPolicy.getBackoffTime((ServerName)serverName, (byte[])regionName, serverStats);
                groupByBackoff.computeIfAbsent(backoff, k -> new ServerRequest()).setRegionRequest((byte[])regionName, (RegionRequest)regionReq);
            });
            groupByBackoff.forEach((backoff, sr) -> {
                if (backoff > 0L) {
                    metrics.ifPresent(m -> m.incrDelayRunnersAndUpdateDelayInterval((long)backoff));
                    this.retryTimer.newTimeout(timer -> this.sendToServer((ServerName)serverName, (ServerRequest)sr, tries), (long)backoff, TimeUnit.MILLISECONDS);
                } else {
                    metrics.ifPresent(MetricsConnection::incrNormalRunners);
                    this.sendToServer((ServerName)serverName, (ServerRequest)sr, tries);
                }
            });
        });
    }

    private void onError(Map<byte[], RegionRequest> actionsByRegion, int tries, Throwable t, ServerName serverName) {
        Throwable error = ConnectionUtils.translateException(t);
        this.logRegionsException(tries, () -> actionsByRegion.values().stream(), error, serverName);
        actionsByRegion.forEach((rn, regionReq) -> this.conn.getLocator().updateCachedLocationOnError(regionReq.loc, error));
        if (error instanceof DoNotRetryIOException || tries >= this.maxAttempts) {
            this.failAll(actionsByRegion.values().stream().flatMap(r -> r.actions.stream()), tries, error, serverName);
            return;
        }
        List<Action> copiedActions = actionsByRegion.values().stream().flatMap(r -> r.actions.stream()).collect(Collectors.toList());
        this.addError(copiedActions, error, serverName);
        this.tryResubmit(copiedActions.stream(), tries, error instanceof RetryImmediatelyException, error);
    }

    private void tryResubmit(Stream<Action> actions, int tries, boolean immediately, Throwable error) {
        if (immediately) {
            this.groupAndSend(actions, tries);
            return;
        }
        OptionalLong maybePauseNsToUse = this.pauseManager.getPauseNsFromException(error, tries, this.startNs);
        if (!maybePauseNsToUse.isPresent()) {
            this.failAll(actions, tries);
            return;
        }
        long delayNs = maybePauseNsToUse.getAsLong();
        if (HBaseServerException.isServerOverloaded(error)) {
            Optional<MetricsConnection> metrics = this.conn.getConnectionMetrics();
            metrics.ifPresent(m -> m.incrementServerOverloadedBackoffTime(delayNs, TimeUnit.NANOSECONDS));
        }
        this.retryTimer.newTimeout(t -> this.groupAndSend(actions, tries + 1), delayNs, TimeUnit.NANOSECONDS);
    }

    private void groupAndSend(Stream<Action> actions, int tries) {
        long locateTimeoutNs;
        if (this.operationTimeoutNs > 0L) {
            locateTimeoutNs = this.pauseManager.remainingTimeNs(this.startNs);
            if (locateTimeoutNs <= 0L) {
                this.failAll(actions, tries);
                return;
            }
        } else {
            locateTimeoutNs = -1L;
        }
        ConcurrentHashMap actionsByServer = new ConcurrentHashMap();
        ConcurrentLinkedQueue locateFailed = new ConcurrentLinkedQueue();
        FutureUtils.addListener(CompletableFuture.allOf((CompletableFuture[])actions.map(action -> this.conn.getLocator().getRegionLocation(this.tableName, action.getAction().getRow(), RegionLocateType.CURRENT, locateTimeoutNs).whenComplete((loc, error) -> {
            if (error != null) {
                if ((error = FutureUtils.unwrapCompletionException(ConnectionUtils.translateException(error))) instanceof DoNotRetryIOException) {
                    this.failOne((Action)action, tries, (Throwable)error, EnvironmentEdgeManager.currentTime(), "");
                    return;
                }
                this.addError((Action)action, (Throwable)error, null);
                locateFailed.add(action);
            } else {
                ConcurrentMapUtils.computeIfAbsent(actionsByServer, loc.getServerName(), () -> new ServerRequest()).addAction((HRegionLocation)loc, (Action)action);
            }
        })).toArray(CompletableFuture[]::new)), (v, r) -> {
            if (!actionsByServer.isEmpty()) {
                this.sendOrDelay(actionsByServer, tries);
            }
            if (!locateFailed.isEmpty()) {
                this.tryResubmit(locateFailed.stream(), tries, false, null);
            }
        });
    }

    public List<CompletableFuture<T>> call() {
        this.groupAndSend(this.actions.stream(), 1);
        return this.futures;
    }

    private static final class ServerRequest {
        public final ConcurrentMap<byte[], RegionRequest> actionsByRegion = new ConcurrentSkipListMap<byte[], RegionRequest>(Bytes.BYTES_COMPARATOR);

        private ServerRequest() {
        }

        public void addAction(HRegionLocation loc, Action action) {
            ConcurrentMapUtils.computeIfAbsent(this.actionsByRegion, loc.getRegion().getRegionName(), (Supplier<RegionRequest>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addAction$0(org.apache.hadoop.hbase.HRegionLocation ), ()Lorg/apache/hadoop/hbase/client/AsyncBatchRpcRetryingCaller$RegionRequest;)((HRegionLocation)loc)).actions.add(action);
        }

        public void setRegionRequest(byte[] regionName, RegionRequest regionReq) {
            this.actionsByRegion.put(regionName, regionReq);
        }

        public int getPriority() {
            return this.actionsByRegion.values().stream().flatMap(rr -> rr.actions.stream()).mapToInt(Action::getPriority).max().orElse(-1);
        }

        private static /* synthetic */ RegionRequest lambda$addAction$0(HRegionLocation loc) {
            return new RegionRequest(loc);
        }
    }

    static final class RegionRequest {
        public final HRegionLocation loc;
        public final ConcurrentLinkedQueue<Action> actions = new ConcurrentLinkedQueue();

        public RegionRequest(HRegionLocation loc) {
            this.loc = loc;
        }
    }
}

