/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.master.procedure.TestFlushTableProcedureBase;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestFlushTableProcedure
extends TestFlushTableProcedureBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFlushTableProcedure.class);

    @Test
    public void testSimpleFlush() throws IOException {
        this.assertTableMemStoreNotEmpty();
        TEST_UTIL.getAdmin().flush(this.TABLE_NAME);
        this.assertTableMemStoreEmpty();
    }

    @Test
    public void testFlushTableExceptionally() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        admin.disableTable(this.TABLE_NAME);
        Assert.assertThrows(TableNotEnabledException.class, () -> admin.flush(this.TABLE_NAME));
        admin.deleteTable(this.TABLE_NAME);
        Assert.assertThrows(TableNotFoundException.class, () -> admin.flush(this.TABLE_NAME));
    }

    @Test
    public void testSingleColumnFamilyFlush() throws IOException {
        this.assertTableMemStoreNotEmpty();
        TEST_UTIL.getAdmin().flush(this.TABLE_NAME, Arrays.asList(this.FAMILY1, this.FAMILY2, this.FAMILY3));
        this.assertTableMemStoreEmpty();
    }

    @Test
    public void testMultiColumnFamilyFlush() throws IOException {
        this.assertTableMemStoreNotEmpty();
        TEST_UTIL.getAdmin().flush(this.TABLE_NAME, Arrays.asList(this.FAMILY1, this.FAMILY2, this.FAMILY3));
        this.assertTableMemStoreEmpty();
    }
}

