/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestAssignmentManagerLoadMetaRegionState {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAssignmentManagerLoadMetaRegionState.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRestart() throws InterruptedException, IOException {
        ServerName sn = UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName();
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        HashSet regions = new HashSet(am.getRegionsOnServer(sn));
        UTIL.getMiniHBaseCluster().stopMaster(0).join();
        HMaster newMaster = UTIL.getMiniHBaseCluster().startMaster().getMaster();
        UTIL.waitFor(30000L, () -> newMaster.isInitialized());
        am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        List newRegions = am.getRegionsOnServer(sn);
        Assert.assertEquals((long)regions.size(), (long)newRegions.size());
        for (RegionInfo region : newRegions) {
            Assert.assertTrue((boolean)regions.contains(region));
        }
    }
}

