/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationStatus;
import org.apache.hadoop.hbase.tmpl.regionserver.ReplicationStatusTmpl;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class ReplicationStatusTmplImpl
extends AbstractTemplateImpl
implements ReplicationStatusTmpl.Intf {
    private final HRegionServer regionServer;

    protected static ReplicationStatusTmpl.ImplData __jamon_setOptionalArguments(ReplicationStatusTmpl.ImplData p_implData) {
        return p_implData;
    }

    public ReplicationStatusTmplImpl(TemplateManager p_templateManager, ReplicationStatusTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)ReplicationStatusTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.regionServer = p_implData.getRegionServer();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        Map<String, ReplicationStatus> walGroupsReplicationStatus = this.regionServer.getWalGroupsReplicationStatus();
        if (walGroupsReplicationStatus != null && walGroupsReplicationStatus.size() > 0) {
            jamonWriter.write("\n\n    <div class=\"tabbable\">\n        <ul class=\"nav nav-pills\" role=\"tablist\">\n            <li class=\"nav-item\"><a class=\"nav-link active\" href=\"#tab_currentLog\" data-bs-toggle=\"tab\" role=\"tab\">Current Log</a> </li>\n            <li class=\"nav-item\"><a class=\"nav-link\" href=\"#tab_replicationDelay\" data-bs-toggle=\"tab\" role=\"tab\">Replication Delay</a></li>\n        </ul>\n        <div class=\"tab-content\">\n            <div class=\"tab-pane active\" id=\"tab_currentLog\" role=\"tabpanel\">\n                ");
            this.__jamon_innerUnit__currentLog(jamonWriter, walGroupsReplicationStatus);
            jamonWriter.write("\n            </div>\n            <div class=\"tab-pane\" id=\"tab_replicationDelay\" role=\"tabpanel\">\n                ");
            this.__jamon_innerUnit__replicationDelay(jamonWriter, walGroupsReplicationStatus);
            jamonWriter.write("\n            </div>\n        </div>\n    </div>\n    <p> If the replication delay is UNKNOWN, that means this walGroup doesn't start replicate yet and it may get disabled.\n    If the size of log is 0, it means we are replicating current HLog, thus we can't get accurate size since it's not closed yet.</p>\n\n");
        } else {
            jamonWriter.write("\n    <p>No Replication Metrics for Peers</p>\n");
        }
        jamonWriter.write("\n\n");
    }

    private void __jamon_innerUnit__currentLog(Writer jamonWriter, Map<String, ReplicationStatus> metrics) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>PeerId</th>\n            <th>WalGroup</th>\n            <th>Current Log</th>\n            <th>Size</th>\n            <th>Queue Size</th>\n            <th>Offset</th>\n        </tr>\n            ");
        for (Map.Entry<String, ReplicationStatus> entry : metrics.entrySet()) {
            jamonWriter.write("\n                 <tr>\n                     <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)entry.getValue().getPeerId()), jamonWriter);
            jamonWriter.write("</td>\n                     <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)entry.getValue().getWalGroup()), jamonWriter);
            jamonWriter.write("</td>\n                     <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((Object)entry.getValue().getCurrentPath()), jamonWriter);
            jamonWriter.write(" </td>\n                     <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanSize((double)entry.getValue().getFileSize())), jamonWriter);
            jamonWriter.write("</td>\n                     <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((int)entry.getValue().getQueueSize()), jamonWriter);
            jamonWriter.write("</td>\n                     <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanSize((double)entry.getValue().getCurrentPosition())), jamonWriter);
            jamonWriter.write("</td>\n                 </tr>\n            ");
        }
        jamonWriter.write("\n    </table>\n");
    }

    private void __jamon_innerUnit__replicationDelay(Writer jamonWriter, Map<String, ReplicationStatus> metrics) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <th>PeerId</th>\n            <th>WalGroup</th>\n            <th>Current Log</th>\n            <th>Last Shipped Age</th>\n            <th>Replication Delay</th>\n        </tr>\n            ");
        for (Map.Entry<String, ReplicationStatus> entry : metrics.entrySet()) {
            jamonWriter.write("\n                 <tr>\n                     <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)entry.getValue().getPeerId()), jamonWriter);
            jamonWriter.write("</td>\n                     <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)entry.getValue().getWalGroup()), jamonWriter);
            jamonWriter.write("</td>\n                     <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((Object)entry.getValue().getCurrentPath()), jamonWriter);
            jamonWriter.write(" </td>\n                     <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanTimeDiff((long)entry.getValue().getAgeOfLastShippedOp())), jamonWriter);
            jamonWriter.write("</td>\n                     <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)(entry.getValue().getReplicationDelay() == Long.MAX_VALUE ? "UNKNOWN" : StringUtils.humanTimeDiff((long)entry.getValue().getReplicationDelay()))), jamonWriter);
            jamonWriter.write("</td>\n                 </tr>\n            ");
        }
        jamonWriter.write("\n    </table>\n");
    }
}

