/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.RoundRobinTableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRoundRobinTableInputFormat {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRoundRobinTableInputFormat.class);
    private static final int SERVERS_COUNT = 5;
    private static final String[] KEYS = new String[]{"aa", "ab", "ac", "ad", "ae", "ba", "bb", "bc", "bd", "be", "ca", "cb", "cc", "cd", "ce", "da", "db", "dc", "dd", "de", "ea", "eb", "ec", "ed", "ee", "fa", "fb", "fc", "fd", "fe", "ga", "gb", "gc", "gd", "ge", "ha", "hb", "hc", "hd", "he", "ia", "ib", "ic", "id", "ie", "ja", "jb", "jc", "jd", "je", "jf"};

    @Test
    public void testRoundRobinSplit() throws IOException, InterruptedException {
        List<InputSplit> splits = this.createSplits();
        Collections.shuffle(splits);
        List sortedSplits = new RoundRobinTableInputFormat().roundRobin(splits);
        this.testDistribution(sortedSplits);
        ArrayList copy = new ArrayList(sortedSplits);
        Arrays.sort(copy.toArray(new InputSplit[0]), new SplitComparator());
        for (int i = 0; i < sortedSplits.size(); ++i) {
            TableSplit sortedTs = (TableSplit)sortedSplits.get(i);
            TableSplit copyTs = (TableSplit)copy.get(i);
            Assert.assertEquals((Object)sortedTs.getEncodedRegionName(), (Object)copyTs.getEncodedRegionName());
        }
    }

    private List<InputSplit> createSplits() {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(KEYS.length - 1);
        for (int i = 0; i < KEYS.length - 1; ++i) {
            TableSplit split = new TableSplit(TableName.valueOf((String)"test"), new Scan(), Bytes.toBytes((String)KEYS[i]), Bytes.toBytes((String)KEYS[i + 1]), String.valueOf(i % 5 + 1), "", 0L);
            splits.add((InputSplit)split);
        }
        return splits;
    }

    private void testDistribution(List<InputSplit> list) throws IOException, InterruptedException {
        for (int i = 0; i < KEYS.length / 5; ++i) {
            int[] counts = new int[5];
            for (int j = i * 5; j < i * 5 + 5; ++j) {
                int n = Integer.parseInt(list.get(j).getLocations()[0]) - 1;
                counts[n] = counts[n] + 1;
            }
            for (int value : counts) {
                Assert.assertEquals((long)value, (long)1L);
            }
        }
    }

    private void assertLengthDescending(List<InputSplit> list) throws IOException, InterruptedException {
        long previousLength = Long.MAX_VALUE;
        for (InputSplit is : list) {
            long length = is.getLength();
            Assert.assertTrue((String)(previousLength + " " + length), (previousLength > length ? 1 : 0) != 0);
            previousLength = length;
        }
    }

    @Test
    public void testConfigureUnconfigure() {
        Configuration configuration = HBaseConfiguration.create();
        RoundRobinTableInputFormat rrtif = new RoundRobinTableInputFormat();
        rrtif.setConf(configuration);
        JobContext jobContext = (JobContext)Mockito.mock(JobContext.class);
        Mockito.when((Object)jobContext.getConfiguration()).thenReturn((Object)configuration);
        configuration.unset(RoundRobinTableInputFormat.HBASE_REGIONSIZECALCULATOR_ENABLE);
        rrtif.configure();
        rrtif.unconfigure();
        String value = configuration.get(RoundRobinTableInputFormat.HBASE_REGIONSIZECALCULATOR_ENABLE);
        Assert.assertNull((Object)value);
        this.checkRetainsBooleanValue(jobContext, rrtif, false);
        this.checkRetainsBooleanValue(jobContext, rrtif, true);
    }

    private void checkRetainsBooleanValue(JobContext jobContext, RoundRobinTableInputFormat rrtif, boolean b) {
        jobContext.getConfiguration().setBoolean(RoundRobinTableInputFormat.HBASE_REGIONSIZECALCULATOR_ENABLE, b);
        rrtif.configure();
        rrtif.unconfigure();
        String value = jobContext.getConfiguration().get(RoundRobinTableInputFormat.HBASE_REGIONSIZECALCULATOR_ENABLE);
        Assert.assertEquals((Object)b, (Object)Boolean.valueOf(value));
    }

    private static class SplitComparator
    implements Comparator<InputSplit> {
        private SplitComparator() {
        }

        @Override
        public int compare(InputSplit o1, InputSplit o2) {
            try {
                return Long.compare(o1.getLength(), o2.getLength());
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("exception in compare", e);
            }
        }
    }
}

