/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.notification;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.commons.lang.StringUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class HookNotification
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String UNKNOW_USER = "UNKNOWN";
    protected HookNotificationType type;
    protected String user;

    public HookNotification() {
    }

    public HookNotification(HookNotificationType type, String user) {
        this.type = type;
        this.user = user;
    }

    public HookNotificationType getType() {
        return this.type;
    }

    public void setType(HookNotificationType type) {
        this.type = type;
    }

    public String getUser() {
        if (StringUtils.isEmpty((String)this.user)) {
            return UNKNOW_USER;
        }
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void normalize() {
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("HookNotification{");
        sb.append("type=").append((Object)this.type);
        sb.append(", user=").append(this.user);
        sb.append("}");
        return sb;
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class EntityDeleteRequestV2
    extends HookNotification
    implements Serializable {
        private List<AtlasObjectId> entities;

        private EntityDeleteRequestV2() {
        }

        public EntityDeleteRequestV2(String user, List<AtlasObjectId> entities) {
            super(HookNotificationType.ENTITY_DELETE_V2, user);
            this.entities = entities;
        }

        public List<AtlasObjectId> getEntities() {
            return this.entities;
        }

        @Override
        public String toString() {
            return this.entities == null ? "null" : this.entities.toString();
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class EntityPartialUpdateRequestV2
    extends HookNotification
    implements Serializable {
        private AtlasObjectId entityId;
        private AtlasEntity.AtlasEntityWithExtInfo entity;

        private EntityPartialUpdateRequestV2() {
        }

        public EntityPartialUpdateRequestV2(String user, AtlasObjectId entityId, AtlasEntity.AtlasEntityWithExtInfo entity) {
            super(HookNotificationType.ENTITY_PARTIAL_UPDATE_V2, user);
            this.entityId = entityId;
            this.entity = entity;
        }

        public AtlasObjectId getEntityId() {
            return this.entityId;
        }

        public AtlasEntity.AtlasEntityWithExtInfo getEntity() {
            return this.entity;
        }

        @Override
        public String toString() {
            return "entityId=" + this.entityId + "; entity=" + this.entity;
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class EntityUpdateRequestV2
    extends HookNotification
    implements Serializable {
        private AtlasEntity.AtlasEntitiesWithExtInfo entities;

        private EntityUpdateRequestV2() {
        }

        public EntityUpdateRequestV2(String user, AtlasEntity.AtlasEntitiesWithExtInfo entities) {
            super(HookNotificationType.ENTITY_FULL_UPDATE_V2, user);
            this.entities = entities;
        }

        public AtlasEntity.AtlasEntitiesWithExtInfo getEntities() {
            return this.entities;
        }

        @Override
        public String toString() {
            return this.entities == null ? "null" : this.entities.toString();
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class EntityCreateRequestV2
    extends HookNotification
    implements Serializable {
        private AtlasEntity.AtlasEntitiesWithExtInfo entities;

        private EntityCreateRequestV2() {
        }

        public EntityCreateRequestV2(String user, AtlasEntity.AtlasEntitiesWithExtInfo entities) {
            super(HookNotificationType.ENTITY_CREATE_V2, user);
            this.entities = entities;
        }

        public AtlasEntity.AtlasEntitiesWithExtInfo getEntities() {
            return this.entities;
        }

        @Override
        public String toString() {
            return this.entities == null ? "null" : this.entities.toString();
        }
    }

    public static enum HookNotificationType {
        TYPE_CREATE,
        TYPE_UPDATE,
        ENTITY_CREATE,
        ENTITY_PARTIAL_UPDATE,
        ENTITY_FULL_UPDATE,
        ENTITY_DELETE,
        ENTITY_CREATE_V2,
        ENTITY_PARTIAL_UPDATE_V2,
        ENTITY_FULL_UPDATE_V2,
        ENTITY_DELETE_V2;

    }
}

