/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasTypeDefHeader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String guid;
    private String name;
    private String serviceType = null;
    private TypeCategory category;

    public AtlasTypeDefHeader() {
        this(null, null, null);
    }

    public AtlasTypeDefHeader(String guid, String name, TypeCategory category) {
        this.guid = guid;
        this.name = name;
        this.category = category;
    }

    public AtlasTypeDefHeader(String guid, String name, TypeCategory category, String serviceType) {
        this(guid, name, category);
        this.serviceType = serviceType;
    }

    public AtlasTypeDefHeader(AtlasBaseTypeDef typeDef) {
        this(typeDef.getGuid(), typeDef.getName(), typeDef.getCategory(), typeDef.getServiceType());
    }

    public AtlasTypeDefHeader(AtlasTypeDefHeader other) {
        if (other == null) {
            this.setGuid(null);
            this.setName(null);
            this.setCategory(null);
            this.setServiceType(null);
        } else {
            this.setGuid(other.getGuid());
            this.setName(other.getName());
            this.setCategory(other.getCategory());
            this.setServiceType(other.getServiceType());
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TypeCategory getCategory() {
        return this.category;
    }

    public void setCategory(TypeCategory category) {
        this.category = category;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtlasTypeDefHeader that = (AtlasTypeDefHeader)o;
        return Objects.equals(this.guid, that.guid) && Objects.equals(this.name, that.name) && Objects.equals(this.serviceType, that.serviceType) && this.category == that.category;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.name, this.category, this.serviceType});
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasTypeDefHeader{");
        sb.append("guid='").append(this.guid).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", typeCategory='").append((Object)this.category).append('\'');
        sb.append(", serviceType='").append(this.serviceType).append('\'');
        sb.append('}');
        return sb;
    }
}

