/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasBusinessMetadataType
extends AtlasStructType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasBusinessMetadataType.class);
    private final AtlasBusinessMetadataDef businessMetadataDef;

    public AtlasBusinessMetadataType(AtlasBusinessMetadataDef businessMetadataDef) {
        super(businessMetadataDef);
        this.businessMetadataDef = businessMetadataDef;
    }

    @Override
    public boolean isValidValue(Object o) {
        return true;
    }

    @Override
    public AtlasStruct createDefaultValue() {
        return null;
    }

    @Override
    public Object getNormalizedValue(Object a) {
        return null;
    }

    public AtlasBusinessMetadataDef getBusinessMetadataDef() {
        return this.businessMetadataDef;
    }

    @Override
    void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferences(typeRegistry);
        HashMap<String, AtlasBusinessAttribute> a = new HashMap<String, AtlasBusinessAttribute>();
        for (AtlasStructType.AtlasAttribute attribute : this.allAttributes.values()) {
            AtlasBusinessAttribute bmAttribute;
            AtlasStructDef.AtlasAttributeDef attributeDef = attribute.getAttributeDef();
            String attrName = attribute.getName();
            AtlasType attrType = attribute.getAttributeType();
            if (attrType instanceof AtlasArrayType) {
                attrType = ((AtlasArrayType)attrType).getElementType();
            } else if (attrType instanceof AtlasMapType) {
                attrType = ((AtlasMapType)attrType).getValueType();
            }
            if (attrType instanceof AtlasStructType) {
                throw new AtlasBaseException(AtlasErrorCode.BUSINESS_METADATA_DEF_ATTRIBUTE_TYPE_INVALID, this.getTypeName(), attrName);
            }
            Set<String> entityTypeNames = attribute.getOptionSet("applicableEntityTypes");
            HashSet<AtlasEntityType> entityTypes = new HashSet<AtlasEntityType>();
            if (CollectionUtils.isNotEmpty(entityTypeNames)) {
                for (String entityTypeName : entityTypeNames) {
                    AtlasEntityType entityType = typeRegistry.getEntityTypeByName(entityTypeName);
                    if (entityType == null) {
                        throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_NOT_FOUND, entityTypeName);
                    }
                    entityTypes.add(entityType);
                }
            }
            if (attrType instanceof AtlasBuiltInTypes.AtlasStringType) {
                Integer maxStringLength = attribute.getOptionInt("maxStrLength");
                if (maxStringLength == null) {
                    throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ATTRIBUTE, attributeDef.getName(), "options.maxStrLength");
                }
                String validPattern = attribute.getOptionString("validPattern");
                bmAttribute = new AtlasBusinessAttribute(attribute, entityTypes, maxStringLength, validPattern);
            } else {
                bmAttribute = new AtlasBusinessAttribute(attribute, entityTypes);
            }
            a.put(attrName, bmAttribute);
        }
        this.allAttributes = Collections.unmodifiableMap(a);
    }

    @Override
    void resolveReferencesPhase2(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferencesPhase2(typeRegistry);
        for (AtlasStructType.AtlasAttribute attribute : this.allAttributes.values()) {
            AtlasBusinessAttribute bmAttribute = (AtlasBusinessAttribute)attribute;
            Set<AtlasEntityType> entityTypes = bmAttribute.getApplicableEntityTypes();
            if (!CollectionUtils.isNotEmpty(entityTypes)) continue;
            for (AtlasEntityType entityType : entityTypes) {
                entityType.addBusinessAttribute(bmAttribute);
            }
        }
    }

    public static class AtlasBusinessAttribute
    extends AtlasStructType.AtlasAttribute {
        private final Set<AtlasEntityType> applicableEntityTypes;
        private final int maxStringLength;
        private final String validPattern;

        public AtlasBusinessAttribute(AtlasStructType.AtlasAttribute attribute, Set<AtlasEntityType> applicableEntityTypes) {
            super(attribute);
            this.maxStringLength = 0;
            this.validPattern = null;
            this.applicableEntityTypes = applicableEntityTypes;
        }

        public AtlasBusinessAttribute(AtlasStructType.AtlasAttribute attribute, Set<AtlasEntityType> applicableEntityTypes, int maxStringLength, String validPattern) {
            super(attribute);
            this.maxStringLength = maxStringLength;
            this.validPattern = validPattern;
            this.applicableEntityTypes = applicableEntityTypes;
        }

        @Override
        public AtlasBusinessMetadataType getDefinedInType() {
            return (AtlasBusinessMetadataType)super.getDefinedInType();
        }

        public Set<AtlasEntityType> getApplicableEntityTypes() {
            return this.applicableEntityTypes;
        }

        public String getValidPattern() {
            return this.validPattern;
        }

        public int getMaxStringLength() {
            return this.maxStringLength;
        }

        public boolean isValidLength(Object value) {
            boolean ret = true;
            if (value != null) {
                AtlasType attrType = this.getAttributeType();
                if (attrType instanceof AtlasBuiltInTypes.AtlasStringType) {
                    ret = this.isValidStringValue(value);
                } else if (attrType instanceof AtlasArrayType && (attrType = ((AtlasArrayType)attrType).getElementType()) instanceof AtlasBuiltInTypes.AtlasStringType) {
                    ret = this.isValidArrayValue(value);
                }
            }
            return ret;
        }

        private boolean isValidStringValue(Object obj) {
            return obj == null || String.valueOf(obj).length() <= this.maxStringLength;
        }

        private boolean isValidArrayValue(Object obj) {
            block3: {
                block2: {
                    if (!(obj instanceof List) && !(obj instanceof Set)) break block2;
                    Collection objList = (Collection)obj;
                    for (Object element : objList) {
                        if (this.isValidStringValue(element)) continue;
                        return false;
                    }
                    break block3;
                }
                if (!obj.getClass().isArray()) break block3;
                int arrayLen = Array.getLength(obj);
                for (int i = 0; i < arrayLen; ++i) {
                    if (this.isValidStringValue(Array.get(obj, i))) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

