/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.io.Console;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationUtil.class);

    private AuthenticationUtil() {
    }

    public static boolean isKerberosAuthenticationEnabled() {
        return AuthenticationUtil.isKerberosAuthenticationEnabled((UserGroupInformation)null);
    }

    public static boolean isKerberosAuthenticationEnabled(UserGroupInformation ugi) {
        boolean defaultValue = ugi != null && ugi.hasKerberosCredentials();
        try {
            return AuthenticationUtil.isKerberosAuthenticationEnabled(ApplicationProperties.get(), defaultValue);
        }
        catch (AtlasException e) {
            LOG.error("Error while isKerberosAuthenticationEnabled ", (Throwable)e);
            return defaultValue;
        }
    }

    public static boolean isKerberosAuthenticationEnabled(Configuration atlasConf) {
        return AuthenticationUtil.isKerberosAuthenticationEnabled(atlasConf, false);
    }

    public static boolean isKerberosAuthenticationEnabled(Configuration atlasConf, boolean defaultValue) {
        return atlasConf.getBoolean("atlas.authentication.method.kerberos", defaultValue);
    }

    public static boolean includeHadoopGroups() {
        boolean includeHadoopGroups = false;
        try {
            Configuration configuration = ApplicationProperties.get();
            includeHadoopGroups = configuration.getBoolean("atlas.authentication.ugi-groups.include-hadoop-groups", includeHadoopGroups);
        }
        catch (AtlasException e) {
            LOG.error("AuthenticationUtil::includeHadoopGroups(). Error while loading atlas application properties ", (Throwable)e);
        }
        return includeHadoopGroups;
    }

    public static String[] getBasicAuthenticationInput() {
        String username = null;
        String password = null;
        try {
            Console console = System.console();
            if (console == null) {
                System.err.println("Couldn't get a console object for user input");
                System.exit(1);
            }
            username = console.readLine("Enter username for atlas :- ", new Object[0]);
            char[] pwdChar = console.readPassword("Enter password for atlas :- ", new Object[0]);
            if (pwdChar != null) {
                password = new String(pwdChar);
            }
        }
        catch (Exception e) {
            System.out.print("Error while reading user input");
            System.exit(1);
        }
        return new String[]{username, password};
    }
}

