/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.predicate.compare;

import java.util.regex.Pattern;
import org.apache.hadoop.hive.accumulo.predicate.compare.PrimitiveComparison;

public class StringCompare
implements PrimitiveComparison {
    private String constant;

    @Override
    public void init(byte[] constant) {
        this.constant = this.serialize(constant);
    }

    @Override
    public boolean isEqual(byte[] value) {
        return this.serialize(value).equals(this.constant);
    }

    @Override
    public boolean isNotEqual(byte[] value) {
        return !this.isEqual(value);
    }

    @Override
    public boolean greaterThanOrEqual(byte[] value) {
        return this.serialize(value).compareTo(this.constant) >= 0;
    }

    @Override
    public boolean greaterThan(byte[] value) {
        return this.serialize(value).compareTo(this.constant) > 0;
    }

    @Override
    public boolean lessThanOrEqual(byte[] value) {
        return this.serialize(value).compareTo(this.constant) <= 0;
    }

    @Override
    public boolean lessThan(byte[] value) {
        return this.serialize(value).compareTo(this.constant) < 0;
    }

    @Override
    public boolean like(byte[] value) {
        String temp = new String(value).replace("%", "[\\\\\\w]+?");
        Pattern pattern = Pattern.compile(temp);
        boolean match = pattern.matcher(this.constant).matches();
        return match;
    }

    @Override
    public String serialize(byte[] value) {
        return new String(value);
    }
}

