/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf.valcoersion;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.valcoersion.VariableCoercion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaIOTmpdirVariableCoercion
extends VariableCoercion {
    private static final Logger LOG = LoggerFactory.getLogger(JavaIOTmpdirVariableCoercion.class);
    private static final String NAME = "system:java.io.tmpdir";
    private static final FileSystem LOCAL_FILE_SYSTEM = new LocalFileSystem();
    public static final JavaIOTmpdirVariableCoercion INSTANCE = new JavaIOTmpdirVariableCoercion();

    private JavaIOTmpdirVariableCoercion() {
        super(NAME);
    }

    private String coerce(String originalValue) {
        if (originalValue == null || originalValue.isEmpty()) {
            return originalValue;
        }
        try {
            Path originalPath = new Path(originalValue);
            Path absolutePath = FileUtils.makeAbsolute(LOCAL_FILE_SYSTEM, originalPath);
            return absolutePath.toString();
        }
        catch (IOException exception) {
            LOG.warn("Unable to resolve 'java.io.tmpdir' for absolute path '{}'", (Object)originalValue);
            return originalValue;
        }
    }

    @Override
    public String getCoerced(String originalValue) {
        return this.coerce(originalValue);
    }
}

