/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.exim;

import com.google.common.base.Function;
import java.util.Collections;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.api.repl.commands.ExportCommand;
import org.apache.hive.hcatalog.api.repl.commands.ImportCommand;
import org.apache.hive.hcatalog.messaging.AlterPartitionMessage;

public class AlterPartitionReplicationTask
extends ReplicationTask {
    AlterPartitionMessage alterPartitionMessage = null;

    public AlterPartitionReplicationTask(HCatNotificationEvent event) {
        super(event);
        this.validateEventType(event, "ALTER_PARTITION");
        this.alterPartitionMessage = messageFactory.getDeserializer().getAlterPartitionMessage(event.getMessage());
    }

    @Override
    public boolean needsStagingDirs() {
        return true;
    }

    @Override
    public Iterable<? extends Command> getSrcWhCommands() {
        this.verifyActionable();
        return Collections.singletonList(new ExportCommand(this.alterPartitionMessage.getDB(), this.alterPartitionMessage.getTable(), this.alterPartitionMessage.getKeyValues(), this.srcStagingDirProvider.getStagingDirectory(ReplicationUtils.getUniqueKey(this.getEvent().getEventId(), this.alterPartitionMessage.getDB(), this.alterPartitionMessage.getTable(), this.alterPartitionMessage.getKeyValues())), true, this.event.getEventId()));
    }

    @Override
    public Iterable<? extends Command> getDstWhCommands() {
        this.verifyActionable();
        String dstDbName = ReplicationUtils.mapIfMapAvailable(this.alterPartitionMessage.getDB(), (Function<String, String>)this.dbNameMapping);
        String dstTableName = ReplicationUtils.mapIfMapAvailable(this.alterPartitionMessage.getTable(), (Function<String, String>)this.tableNameMapping);
        return Collections.singletonList(new ImportCommand(dstDbName, dstTableName, this.alterPartitionMessage.getKeyValues(), this.dstStagingDirProvider.getStagingDirectory(ReplicationUtils.getUniqueKey(this.getEvent().getEventId(), this.alterPartitionMessage.getDB(), this.alterPartitionMessage.getTable(), this.alterPartitionMessage.getKeyValues())), true, this.event.getEventId()));
    }
}

