/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.hive.HiveSchemaConverter;
import org.apache.iceberg.hive.HiveVersion;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.Pair;

public final class HiveSchemaUtil {
    private HiveSchemaUtil() {
    }

    public static List<FieldSchema> convert(Schema schema) {
        return schema.columns().stream().map(col -> new FieldSchema(col.name(), HiveSchemaUtil.convertToTypeString(col.type()), col.doc())).collect(Collectors.toList());
    }

    public static Schema convert(List<FieldSchema> fieldSchemas) {
        return HiveSchemaUtil.convert(fieldSchemas, Collections.emptyMap(), false);
    }

    public static Schema convert(List<FieldSchema> fieldSchemas, Map<String, String> defaultValues, boolean autoConvert) {
        ArrayList names = Lists.newArrayListWithExpectedSize((int)fieldSchemas.size());
        ArrayList typeInfos = Lists.newArrayListWithExpectedSize((int)fieldSchemas.size());
        ArrayList comments = Lists.newArrayListWithExpectedSize((int)fieldSchemas.size());
        for (FieldSchema col : fieldSchemas) {
            names.add(col.getName().toLowerCase());
            typeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString((String)col.getType()));
            comments.add(col.getComment());
        }
        return HiveSchemaConverter.convert(names, typeInfos, comments, autoConvert, defaultValues);
    }

    public static PartitionSpec spec(Schema schema, List<FieldSchema> fieldSchemas) {
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema);
        fieldSchemas.forEach(fieldSchema -> builder.identity(fieldSchema.getName().toLowerCase()));
        return builder.build();
    }

    public static Schema convert(List<String> names, List<TypeInfo> types, List<String> comments) {
        return HiveSchemaConverter.convert(names, types, comments, false, Collections.emptyMap());
    }

    public static Schema convert(List<String> names, List<TypeInfo> types, List<String> comments, boolean autoConvert) {
        return HiveSchemaConverter.convert(names, types, comments, autoConvert, Collections.emptyMap());
    }

    public static TypeInfo convert(Type type) {
        return TypeInfoUtils.getTypeInfoFromTypeString((String)HiveSchemaUtil.convertToTypeString(type));
    }

    public static Type convert(TypeInfo typeInfo, String defaultValue) {
        return HiveSchemaConverter.convert(typeInfo, false, defaultValue);
    }

    public static SchemaDifference getSchemaDiff(Collection<FieldSchema> minuendCollection, Collection<FieldSchema> subtrahendCollection, Schema schema, Map<String, String> defaultValues, boolean bothDirections) {
        SchemaDifference difference = new SchemaDifference();
        for (FieldSchema first : minuendCollection) {
            boolean found = false;
            for (FieldSchema second : subtrahendCollection) {
                if (!Objects.equals(first.getName(), second.getName())) continue;
                found = true;
                if (!Objects.equals(first.getType(), second.getType())) {
                    difference.addTypeChanged(first);
                }
                if (Objects.equals(first.getComment(), second.getComment())) continue;
                difference.addCommentChanged(first);
            }
            if (found) continue;
            difference.addMissingFromSecond(first);
        }
        if (bothDirections) {
            SchemaDifference otherWay = HiveSchemaUtil.getSchemaDiff(subtrahendCollection, minuendCollection, null, defaultValues, false);
            otherWay.getMissingFromSecond().forEach(difference::addMissingFromFirst);
        }
        if (schema != null) {
            for (Types.NestedField field : schema.columns()) {
                if (HiveSchemaUtil.isRemovedField(field, difference.getMissingFromFirst())) continue;
                HiveSchemaUtil.getDefaultValDiff(field, defaultValues, difference);
            }
        }
        return difference;
    }

    private static boolean isRemovedField(Types.NestedField field, List<FieldSchema> missingFields) {
        for (FieldSchema fieldSchema : missingFields) {
            if (!fieldSchema.getName().equalsIgnoreCase(field.name())) continue;
            return true;
        }
        return false;
    }

    private static void getDefaultValDiff(Types.NestedField field, Map<String, String> defaultValues, SchemaDifference difference) {
        String defaultStr = defaultValues.get(field.name());
        if (defaultStr == null && field.writeDefault() == null) {
            return;
        }
        if (field.type().isPrimitiveType()) {
            Object expectedDefault = HiveSchemaUtil.getDefaultValue(defaultStr, field.type());
            if (!Objects.equals(expectedDefault, field.writeDefault())) {
                difference.addDefaultChanged(field, expectedDefault);
            }
        } else if (field.type().isStructType()) {
            Map<String, String> structDefaults = HiveSchemaUtil.getDefaultValuesMap(defaultStr);
            for (Types.NestedField nested : field.type().asStructType().fields()) {
                HiveSchemaUtil.getDefaultValDiff(nested, structDefaults, difference);
            }
        }
    }

    public static Pair<String, Optional<String>> getReorderedColumn(List<FieldSchema> updated, List<FieldSchema> old, Map<String, String> renameMapping) {
        HashMap nameToNewIndex = Maps.newHashMap();
        for (int i = 0; i < updated.size(); ++i) {
            String updatedCol = renameMapping.getOrDefault(updated.get(i).getName(), updated.get(i).getName());
            nameToNewIndex.put(updatedCol, i);
        }
        String reorderedColName = null;
        int maxIndexDiff = 0;
        for (int oldIndex = 0; oldIndex < old.size(); ++oldIndex) {
            int indexDiff;
            String oldName = old.get(oldIndex).getName();
            Integer newIndex = (Integer)nameToNewIndex.get(oldName);
            if (newIndex == null || maxIndexDiff >= (indexDiff = Math.abs(newIndex - oldIndex))) continue;
            maxIndexDiff = indexDiff;
            reorderedColName = oldName;
        }
        if (maxIndexDiff == 0) {
            return null;
        }
        int newIndex = (Integer)nameToNewIndex.get(reorderedColName);
        if (newIndex > 0) {
            String previousColName = renameMapping.getOrDefault(updated.get(newIndex - 1).getName(), updated.get(newIndex - 1).getName());
            return Pair.of((Object)reorderedColName, Optional.of(previousColName));
        }
        return Pair.of(reorderedColName, Optional.empty());
    }

    public static String convertToTypeString(Type type) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return "boolean";
            }
            case INTEGER: {
                return "int";
            }
            case LONG: {
                return "bigint";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case DATE: {
                return "date";
            }
            case TIME: 
            case STRING: 
            case UUID: {
                return "string";
            }
            case TIMESTAMP: {
                Types.TimestampType timestampType = (Types.TimestampType)type;
                if (HiveVersion.min(HiveVersion.HIVE_3) && timestampType.shouldAdjustToUTC()) {
                    return "timestamp with local time zone";
                }
                return "timestamp";
            }
            case FIXED: 
            case BINARY: {
                return "binary";
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return String.format("decimal(%s,%s)", decimalType.precision(), decimalType.scale());
            }
            case STRUCT: {
                Types.StructType structType = type.asStructType();
                String nameToType = structType.fields().stream().map(f -> String.format("%s:%s", f.name(), HiveSchemaUtil.convert(f.type()))).collect(Collectors.joining(","));
                return String.format("struct<%s>", nameToType);
            }
            case LIST: {
                Types.ListType listType = type.asListType();
                return String.format("array<%s>", HiveSchemaUtil.convert(listType.elementType()));
            }
            case MAP: {
                Types.MapType mapType = type.asMapType();
                return String.format("map<%s,%s>", HiveSchemaUtil.convert(mapType.keyType()), HiveSchemaUtil.convert(mapType.valueType()));
            }
            case VARIANT: {
                return "variant";
            }
        }
        throw new UnsupportedOperationException(String.valueOf(type) + " is not supported");
    }

    public static void setDefaultValues(Record record, List<Types.NestedField> fields, Set<String> missingColumns) {
        for (Types.NestedField field : fields) {
            Object fieldValue = record.getField(field.name());
            if (fieldValue == null) {
                boolean isMissing = missingColumns.contains(field.name());
                if (!isMissing) continue;
                if (field.type().isStructType()) {
                    GenericRecord nestedRecord = GenericRecord.create((Types.StructType)field.type().asStructType());
                    record.setField(field.name(), (Object)nestedRecord);
                    HiveSchemaUtil.setDefaultValuesForNestedStruct((Record)nestedRecord, field.type().asStructType().fields());
                    continue;
                }
                if (field.writeDefault() == null) continue;
                Object defaultValue = HiveSchemaUtil.convertToWriteType(field.writeDefault(), field.type());
                record.setField(field.name(), defaultValue);
                continue;
            }
            if (!field.type().isStructType() || !(fieldValue instanceof Record)) continue;
            HiveSchemaUtil.setDefaultValuesForNestedStruct((Record)fieldValue, field.type().asStructType().fields());
        }
    }

    private static void setDefaultValuesForNestedStruct(Record record, List<Types.NestedField> fields) {
        for (Types.NestedField field : fields) {
            Object fieldValue = record.getField(field.name());
            if (fieldValue == null && field.writeDefault() != null) {
                Object defaultValue = HiveSchemaUtil.convertToWriteType(field.writeDefault(), field.type());
                record.setField(field.name(), defaultValue);
                continue;
            }
            if (!field.type().isStructType() || !(fieldValue instanceof Record)) continue;
            HiveSchemaUtil.setDefaultValuesForNestedStruct((Record)fieldValue, field.type().asStructType().fields());
        }
    }

    public static Object convertToWriteType(Object value, Type type) {
        if (value == null) {
            return null;
        }
        switch (type.typeId()) {
            case DATE: {
                if (!(value instanceof Integer)) break;
                return DateTimeUtil.dateFromDays((int)((Integer)value));
            }
            case TIMESTAMP: {
                if (!(value instanceof Long)) break;
                Types.TimestampType timestampType = (Types.TimestampType)type;
                return timestampType.shouldAdjustToUTC() ? DateTimeUtil.timestamptzFromMicros((long)((Long)value)) : DateTimeUtil.timestampFromMicros((long)((Long)value));
            }
            default: {
                return value;
            }
        }
        return value;
    }

    public static Map<String, String> getDefaultValuesMap(String defaultValue) {
        if (StringUtils.isEmpty((CharSequence)defaultValue)) {
            return Collections.emptyMap();
        }
        return Splitter.on((char)',').trimResults().withKeyValueSeparator(':').split((CharSequence)HiveSchemaUtil.stripQuotes(defaultValue));
    }

    public static String stripQuotes(String val) {
        if (val.charAt(0) == '\'' && val.charAt(val.length() - 1) == '\'' || val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static Object getDefaultValue(String defaultValue, Type type) {
        if (defaultValue == null) {
            return null;
        }
        return switch (type.typeId()) {
            case Type.TypeID.DATE, Type.TypeID.TIME, Type.TypeID.TIMESTAMP, Type.TypeID.TIMESTAMP_NANO -> Literal.of((CharSequence)HiveSchemaUtil.stripQuotes(defaultValue)).to(type).value();
            default -> Conversions.fromPartitionString((Type)type, (String)HiveSchemaUtil.stripQuotes(defaultValue));
        };
    }

    public static Type getStructType(TypeInfo typeInfo, String defaultValue) {
        return HiveSchemaConverter.convert(typeInfo, false, defaultValue);
    }

    public static class SchemaDifference {
        private final List<FieldSchema> missingFromFirst = Lists.newArrayList();
        private final List<FieldSchema> missingFromSecond = Lists.newArrayList();
        private final List<FieldSchema> typeChanged = Lists.newArrayList();
        private final List<FieldSchema> commentChanged = Lists.newArrayList();
        private final Map<Types.NestedField, Object> defaultChanged = Maps.newHashMap();

        public List<FieldSchema> getMissingFromFirst() {
            return this.missingFromFirst;
        }

        public List<FieldSchema> getMissingFromSecond() {
            return this.missingFromSecond;
        }

        public List<FieldSchema> getTypeChanged() {
            return this.typeChanged;
        }

        public List<FieldSchema> getCommentChanged() {
            return this.commentChanged;
        }

        public Map<Types.NestedField, Object> getDefaultChanged() {
            return this.defaultChanged;
        }

        public boolean isEmpty() {
            return this.missingFromFirst.isEmpty() && this.missingFromSecond.isEmpty() && this.typeChanged.isEmpty() && this.commentChanged.isEmpty() && this.defaultChanged.isEmpty();
        }

        void addMissingFromFirst(FieldSchema field) {
            this.missingFromFirst.add(field);
        }

        void addMissingFromSecond(FieldSchema field) {
            this.missingFromSecond.add(field);
        }

        void addTypeChanged(FieldSchema field) {
            this.typeChanged.add(field);
        }

        void addCommentChanged(FieldSchema field) {
            this.commentChanged.add(field);
        }

        void addDefaultChanged(Types.NestedField field, Object defaultValue) {
            this.defaultChanged.put(field, defaultValue);
        }
    }
}

