/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.DefaultHiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableIterable;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.CreateTableRequest;
import org.apache.hadoop.hive.metastore.api.DropDatabaseRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.RequestPartsSpec;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientWrapper;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HookEnabledMetaStoreClient
extends MetaStoreClientWrapper {
    private final HiveMetaHookLoader hookLoader;
    private static final Logger LOG = LoggerFactory.getLogger(HookEnabledMetaStoreClient.class);

    public static HookEnabledMetaStoreClient newClient(Configuration conf, @Nullable HiveMetaHookLoader hookLoader, IMetaStoreClient delegate) {
        return new HookEnabledMetaStoreClient(conf, hookLoader, delegate);
    }

    public HookEnabledMetaStoreClient(Configuration conf, @Nullable HiveMetaHookLoader hookLoader, IMetaStoreClient delegate) {
        super(delegate, conf);
        this.hookLoader = hookLoader;
    }

    private HiveMetaHook getHook(Table tbl) throws MetaException {
        if (this.hookLoader == null) {
            return null;
        }
        return this.hookLoader.getHook(tbl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter_table(String catName, String dbName, String tbl_name, Table new_tbl, EnvironmentContext envContext, String validWriteIds) throws TException {
        HiveMetaHook hook = this.getHook(new_tbl);
        if (hook != null) {
            hook.preAlterTable(new_tbl, envContext);
        }
        boolean success = false;
        try {
            boolean skipAlter;
            boolean bl = skipAlter = envContext != null && envContext.getProperties() != null && Boolean.valueOf(envContext.getProperties().getOrDefault("skip_metastore_alter", "false")) != false;
            if (!skipAlter) {
                this.delegate.alter_table(catName, dbName, tbl_name, new_tbl, envContext, validWriteIds);
            }
            if (hook != null) {
                hook.commitAlterTable(new_tbl, envContext);
            }
            success = true;
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackAlterTable(new_tbl, envContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(CreateTableRequest request) throws TException {
        Table tbl = request.getTable();
        HiveMetaHook hook = this.getHook(tbl);
        if (hook != null) {
            hook.preCreateTable(request);
        }
        boolean success = false;
        try {
            if (hook == null || !hook.createHMSTableInHook()) {
                this.delegate.createTable(request);
            }
            if (hook != null) {
                hook.commitCreateTable(tbl);
            }
            success = true;
        }
        finally {
            if (!success && hook != null) {
                try {
                    hook.rollbackCreateTable(tbl);
                }
                catch (Exception e) {
                    LOG.error("Create rollback failed with", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws TException {
        CreateTableRequest createTableRequest = new CreateTableRequest(tbl);
        if (!tbl.isSetCatName()) {
            String defaultCat = MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
            tbl.setCatName(defaultCat);
            if (primaryKeys != null) {
                primaryKeys.forEach(pk -> pk.setCatName(defaultCat));
            }
            if (foreignKeys != null) {
                foreignKeys.forEach(fk -> fk.setCatName(defaultCat));
            }
            if (uniqueConstraints != null) {
                uniqueConstraints.forEach(uc -> uc.setCatName(defaultCat));
                createTableRequest.setUniqueConstraints(uniqueConstraints);
            }
            if (notNullConstraints != null) {
                notNullConstraints.forEach(nn -> nn.setCatName(defaultCat));
            }
            if (defaultConstraints != null) {
                defaultConstraints.forEach(def -> def.setCatName(defaultCat));
            }
            if (checkConstraints != null) {
                checkConstraints.forEach(cc -> cc.setCatName(defaultCat));
            }
        }
        if (primaryKeys != null) {
            createTableRequest.setPrimaryKeys(primaryKeys);
        }
        if (foreignKeys != null) {
            createTableRequest.setForeignKeys(foreignKeys);
        }
        if (uniqueConstraints != null) {
            createTableRequest.setUniqueConstraints(uniqueConstraints);
        }
        if (notNullConstraints != null) {
            createTableRequest.setNotNullConstraints(notNullConstraints);
        }
        if (defaultConstraints != null) {
            createTableRequest.setDefaultConstraints(defaultConstraints);
        }
        if (checkConstraints != null) {
            createTableRequest.setCheckConstraints(checkConstraints);
        }
        this.createTable(createTableRequest);
    }

    @Override
    public void dropDatabase(DropDatabaseRequest req) throws TException {
        try {
            this.getDatabase(req.getCatalogName(), req.getName());
        }
        catch (NoSuchObjectException e) {
            if (!req.isIgnoreUnknownDb()) {
                throw e;
            }
            return;
        }
        if (req.isCascade()) {
            List<String> materializedViews = this.getTables(req.getCatalogName(), req.getName(), ".*", TableType.MATERIALIZED_VIEW);
            for (String table : materializedViews) {
                Table materializedView = this.getTable(req.getCatalogName(), req.getName(), table);
                boolean isSoftDelete = req.isSoftDelete() && Boolean.parseBoolean((String)materializedView.getParameters().get("soft_delete"));
                materializedView.setTxnId(req.getTxnId());
                this.dropTable(materializedView, req.isDeleteData() && !isSoftDelete, true, false);
            }
            List<String> tableNameList = this.getAllTables(req.getCatalogName(), req.getName());
            int tableCount = tableNameList.size();
            int maxBatchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
            LOG.debug("Selecting dropDatabase method for " + req.getName() + " (" + tableCount + " tables), " + MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX.getVarname() + "=" + maxBatchSize);
            if (tableCount > maxBatchSize) {
                LOG.debug("Dropping database in a per table batch manner.");
                this.dropDatabaseCascadePerTable(req, tableNameList, maxBatchSize);
            } else {
                LOG.debug("Dropping database in a per DB manner.");
                this.dropDatabaseCascadePerDb(req, tableNameList);
            }
        } else {
            this.delegate.dropDatabase(req);
        }
    }

    private void dropDatabaseCascadePerTable(DropDatabaseRequest req, List<String> tableList, int maxBatchSize) throws TException {
        for (Table table : new TableIterable(this, req.getCatalogName(), req.getName(), tableList, maxBatchSize)) {
            boolean deleteData;
            boolean isSoftDelete = req.isSoftDelete() && Boolean.parseBoolean((String)table.getParameters().get("soft_delete"));
            boolean bl = deleteData = req.isDeleteData() && !isSoftDelete;
            if (req.isSetTxnId()) {
                table.setTxnId(req.getTxnId());
                req.setDeleteManagedDir(false);
            }
            this.dropTable(table, deleteData, false, false);
        }
        this.delegate.dropDatabase(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDatabaseCascadePerDb(DropDatabaseRequest req, List<String> tableList) throws TException {
        HiveMetaHook hook;
        List<Table> tables = this.getTableObjectsByName(req.getCatalogName(), req.getName(), tableList);
        boolean success = false;
        try {
            for (Table table : tables) {
                hook = this.getHook(table);
                if (hook == null) continue;
                hook.preDropTable(table);
            }
            this.delegate.dropDatabase(req);
            for (Table table : tables) {
                hook = this.getHook(table);
                if (hook == null) continue;
                hook.commitDropTable(table, req.isDeleteData());
            }
            success = true;
        }
        finally {
            if (!success) {
                for (Table table : tables) {
                    hook = this.getHook(table);
                    if (hook == null) continue;
                    hook.rollbackDropTable(table);
                }
            }
        }
    }

    @Override
    public List<Partition> dropPartitions(TableName tableName, RequestPartsSpec partsSpec, PartitionDropOptions options, EnvironmentContext context) throws TException {
        Table table = this.delegate.getTable(tableName.getCat(), tableName.getDb(), tableName.getTable());
        HiveMetaHook hook = this.getHook(table);
        if (hook != null) {
            if (context == null) {
                context = new EnvironmentContext();
            }
            hook.preDropPartitions(table, context, partsSpec);
        }
        return this.delegate.dropPartitions(tableName, partsSpec, options, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(Table table, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws TException {
        HiveMetaHook hook = this.getHook(table);
        if (hook != null) {
            hook.preDropTable(table, deleteData || ifPurge);
        }
        boolean success = false;
        try {
            this.delegate.dropTable(table, deleteData, ignoreUnknownTab, ifPurge);
            if (hook != null) {
                hook.commitDropTable(table, deleteData || ifPurge);
            }
            success = true;
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw e;
            }
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackDropTable(table);
            }
        }
    }

    @Override
    public void truncateTable(String catName, String dbName, String tableName, String ref, List<String> partNames, String validWriteIds, long writeId, boolean deleteData, EnvironmentContext context) throws TException {
        Table table = this.getTable(catName, dbName, tableName);
        HiveMetaHook hook = this.getHook(table);
        if (hook != null) {
            if (context == null) {
                context = new EnvironmentContext();
            }
            if (ref != null) {
                context.putToProperties("snapshot_ref", ref);
            }
            context.putToProperties("truncateSkipDataDeletion", Boolean.toString(!deleteData));
            hook.preTruncateTable(table, context, partNames);
        }
        this.delegate.truncateTable(catName, dbName, tableName, ref, partNames, validWriteIds, writeId, deleteData, context);
    }

    @Override
    public Table getTable(GetTableRequest getTableRequest) throws TException {
        Table t = this.delegate.getTable(getTableRequest);
        this.executePostGetTableHook(t);
        return t;
    }

    private void executePostGetTableHook(Table t) throws MetaException {
        HiveMetaHook hook = this.getHook(t);
        if (hook != null) {
            hook.postGetTable(t);
        }
    }

    @Override
    public List<Table> getTables(String catName, String dbName, List<String> tableNames, GetProjectionsSpec projectionsSpec) throws TException {
        List<Table> tabs = this.delegate.getTables(catName, dbName, tableNames, projectionsSpec);
        for (Table tbl : tabs) {
            this.executePostGetTableHook(tbl);
        }
        return tabs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTable(Table table, boolean overwrite) throws MetaException {
        boolean failed = true;
        HiveMetaHook hook = this.getHook(table);
        if (hook == null || !(hook instanceof DefaultHiveMetaHook)) {
            return;
        }
        DefaultHiveMetaHook hiveMetaHook = (DefaultHiveMetaHook)hook;
        try {
            hiveMetaHook.commitInsertTable(table, overwrite);
            failed = false;
        }
        finally {
            if (failed) {
                hiveMetaHook.rollbackInsertTable(table, overwrite);
            }
        }
    }
}

