/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hive.service.auth.ldap.DirSearchFactory;
import org.apache.hive.service.auth.ldap.KerberosLdapFilterEnforcer;
import org.apache.hive.service.auth.ldap.LdapSearchFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapGroupCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LdapGroupCallbackHandler.class);
    private final CallbackHandler delegateHandler;
    private final KerberosLdapFilterEnforcer filterEnforcer;

    public LdapGroupCallbackHandler(HiveConf conf) {
        this(conf, new LdapSearchFactory(), (CallbackHandler)new SaslRpcServer.SaslGssCallbackHandler());
    }

    @VisibleForTesting
    private LdapGroupCallbackHandler(HiveConf conf, DirSearchFactory dirSearchFactory, CallbackHandler delegateHandler) {
        this.delegateHandler = delegateHandler;
        this.filterEnforcer = new KerberosLdapFilterEnforcer(conf, dirSearchFactory);
    }

    @VisibleForTesting
    public static LdapGroupCallbackHandler createForTesting(HiveConf conf, DirSearchFactory dirSearchFactory, CallbackHandler delegateHandler) {
        return new LdapGroupCallbackHandler(conf, dirSearchFactory, delegateHandler);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.delegateHandler.handle(callbacks);
        for (Callback callback : callbacks) {
            if (!(callback instanceof AuthorizeCallback)) continue;
            AuthorizeCallback ac = (AuthorizeCallback)callback;
            if (!ac.isAuthorized()) {
                LOG.debug("Delegate callback rejected {}; skipping LDAP filter", (Object)ac.getAuthenticationID());
                continue;
            }
            String authenticationID = ac.getAuthenticationID();
            boolean authorized = this.filterEnforcer.applyLdapFilter(authenticationID);
            ac.setAuthorized(authorized);
        }
    }
}

