/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.charset.StandardCharsets;
import java.security.SecurityPermission;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.TableMap;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;

public class Tables {
    public static final String VALID_NAME_REGEX = "^(\\w+\\.)?(\\w+)$";
    private static final SecurityPermission TABLES_PERMISSION = new SecurityPermission("tablesPermission");
    private static Cache<String, TableMap> instanceToMapCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();

    private static ZooCache getZooCache(Instance instance) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(TABLES_PERMISSION);
        }
        return new ZooCacheFactory().getZooCache(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut());
    }

    public static String getTableId(Instance instance, String tableName) throws TableNotFoundException {
        try {
            return Tables._getTableId(instance, tableName);
        }
        catch (NamespaceNotFoundException e) {
            throw new TableNotFoundException(tableName, e);
        }
    }

    public static String _getTableId(Instance instance, String tableName) throws NamespaceNotFoundException, TableNotFoundException {
        String tableId = Tables.getNameToIdMap(instance).get(tableName);
        if (tableId == null) {
            Tables.clearCache(instance);
            tableId = Tables.getNameToIdMap(instance).get(tableName);
            if (tableId == null) {
                String namespace = Tables.qualify(tableName).getFirst();
                if (Namespaces.getNameToIdMap(instance).containsKey(namespace)) {
                    throw new TableNotFoundException(null, tableName, null);
                }
                throw new NamespaceNotFoundException(null, namespace, null);
            }
        }
        return tableId;
    }

    public static String getTableName(Instance instance, String tableId) throws TableNotFoundException {
        String tableName = Tables.getIdToNameMap(instance).get(tableId);
        if (tableName == null) {
            throw new TableNotFoundException(tableId, null, null);
        }
        return tableName;
    }

    public static Map<String, String> getNameToIdMap(Instance instance) {
        return Tables.getTableMap(instance).getNameToIdMap();
    }

    public static Map<String, String> getIdToNameMap(Instance instance) {
        return Tables.getTableMap(instance).getIdtoNameMap();
    }

    private static TableMap getTableMap(Instance instance) {
        ZooCache zc = Tables.getZooCache(instance);
        TableMap map = Tables.getTableMap(instance, zc);
        if (!map.isCurrent(zc)) {
            instanceToMapCache.invalidate((Object)instance.getInstanceID());
            map = Tables.getTableMap(instance, zc);
        }
        return map;
    }

    private static TableMap getTableMap(final Instance instance, final ZooCache zc) {
        try {
            return (TableMap)instanceToMapCache.get((Object)instance.getInstanceID(), (Callable)new Callable<TableMap>(){

                @Override
                public TableMap call() {
                    return new TableMap(instance, zc);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean exists(Instance instance, String tableId) {
        ZooCache zc = Tables.getZooCache(instance);
        List tableIds = zc.getChildren(ZooUtil.getRoot(instance) + "/tables");
        return tableIds.contains(tableId);
    }

    public static void clearCache(Instance instance) {
        Tables.getZooCache(instance).clear(ZooUtil.getRoot(instance) + "/tables");
        Tables.getZooCache(instance).clear(ZooUtil.getRoot(instance) + "/namespaces");
        instanceToMapCache.invalidate((Object)instance.getInstanceID());
    }

    public static void clearCacheByPath(Instance instance, String zooPath) {
        String thePath = zooPath.startsWith("/") ? zooPath : "/" + zooPath;
        Tables.getZooCache(instance).clear(ZooUtil.getRoot(instance) + thePath);
        instanceToMapCache.invalidate((Object)instance.getInstanceID());
    }

    public static String getPrintableTableNameFromId(Map<String, String> tidToNameMap, String tableId) {
        String tableName = tidToNameMap.get(tableId);
        return tableName == null ? "(ID:" + tableId + ")" : tableName;
    }

    public static String getPrintableTableInfoFromId(Instance instance, String tableId) {
        String tableName = null;
        try {
            tableName = Tables.getTableName(instance, tableId);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        return tableName == null ? String.format("?(ID:%s)", tableId) : String.format("%s(ID:%s)", tableName, tableId);
    }

    public static String getPrintableTableInfoFromName(Instance instance, String tableName) {
        String tableId = null;
        try {
            tableId = Tables.getTableId(instance, tableName);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        return tableId == null ? String.format("%s(?)", tableName) : String.format("%s(ID:%s)", tableName, tableId);
    }

    public static TableState getTableState(Instance instance, String tableId) {
        return Tables.getTableState(instance, tableId, false);
    }

    public static TableState getTableState(Instance instance, String tableId, boolean clearCachedState) {
        ZooCache zc;
        byte[] state;
        String statePath = ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/state";
        if (clearCachedState) {
            Tables.clearCacheByPath(instance, statePath);
        }
        if ((state = (zc = Tables.getZooCache(instance)).get(statePath)) == null) {
            return TableState.UNKNOWN;
        }
        return TableState.valueOf(new String(state, StandardCharsets.UTF_8));
    }

    public static String qualified(String tableName) {
        return Tables.qualified(tableName, "");
    }

    public static String qualified(String tableName, String defaultNamespace) {
        Pair<String, String> qualifiedTableName = Tables.qualify(tableName, defaultNamespace);
        if ("".equals(qualifiedTableName.getFirst())) {
            return qualifiedTableName.getSecond();
        }
        return qualifiedTableName.toString("", ".", "");
    }

    public static Pair<String, String> qualify(String tableName) {
        return Tables.qualify(tableName, "");
    }

    public static Pair<String, String> qualify(String tableName, String defaultNamespace) {
        if (!tableName.matches(VALID_NAME_REGEX)) {
            throw new IllegalArgumentException("Invalid table name '" + tableName + "'");
        }
        if ("!METADATA".equals(tableName)) {
            tableName = "accumulo.metadata";
        }
        if (tableName.contains(".")) {
            String[] s = tableName.split("\\.", 2);
            return new Pair<String, String>(s[0], s[1]);
        }
        return new Pair<String, String>(defaultNamespace, tableName);
    }

    public static String getNamespaceId(Instance instance, String tableId) throws TableNotFoundException {
        Preconditions.checkArgument((instance != null ? 1 : 0) != 0, (Object)"instance is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        ZooCache zc = Tables.getZooCache(instance);
        byte[] n = zc.get(ZooUtil.getRoot(instance) + "/tables" + "/" + tableId + "/namespace");
        if (null == n) {
            throw new TableNotFoundException(tableId, null, null);
        }
        return new String(n, StandardCharsets.UTF_8);
    }
}

